/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.bungee.connection;

import com.google.common.base.Preconditions;
import com.ishland.raknetify.bungee.RaknetifyBungeePlugin;
import com.ishland.raknetify.common.connection.MultiChannelingStreamingCompression;
import com.ishland.raknetify.common.connection.MultiChannellingEncryption;
import com.ishland.raknetify.common.connection.RakNetSimpleMultiChannelCodec;
import com.ishland.raknetify.common.connection.SynchronizationLayer;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Commands;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.FinishConfiguration;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StartConfiguration;

public class RakNetBungeeClientChannelEventListener
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-bungee-event-listener";
    private SecretKey encryptionKey = null;
    private boolean needResetCompression = false;
    private Protocol protocol = null;
    private int protocolVersion = -1;

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (this.needResetCompression) {
            RaknetifyBungeePlugin.LOGGER.info("Preventing vanilla compression as streaming compression is enabled");
            HandlerBoss handlerBoss = (HandlerBoss)ctx.channel().pipeline().get(HandlerBoss.class);
            Field channelField = HandlerBoss.class.getDeclaredField("channel");
            channelField.setAccessible(true);
            ChannelWrapper channelWrapper = (ChannelWrapper)channelField.get(handlerBoss);
            Preconditions.checkState((channelWrapper != null ? 1 : 0) != 0, (Object)"channelWrapper is null");
            channelWrapper.setCompressionThreshold(-1);
            this.needResetCompression = false;
        }
        if (this.encryptionKey != null) {
            ctx.channel().pipeline().replace("decrypt", "decrypt", (ChannelHandler)new ChannelDuplexHandler());
            ctx.channel().pipeline().replace("encrypt", "encrypt", (ChannelHandler)new ChannelDuplexHandler());
            ctx.channel().pipeline().addBefore("raknetify-multichannel-streaming-compression", "raknetify-multichannel-encryption", (ChannelHandler)new MultiChannellingEncryption(this.encryptionKey));
            this.encryptionKey = null;
        }
        if (msg instanceof SetCompression) {
            MultiChannelingStreamingCompression compression = (MultiChannelingStreamingCompression)ctx.channel().pipeline().get(MultiChannelingStreamingCompression.class);
            if (compression != null && compression.isActive()) {
                RaknetifyBungeePlugin.LOGGER.info("Preventing vanilla compression as streaming compression is enabled");
                promise.setSuccess();
                this.needResetCompression = true;
                return;
            }
        } else {
            if (msg instanceof Respawn || msg instanceof Login || msg instanceof StartConfiguration || msg instanceof FinishConfiguration) {
                ctx.write(SynchronizationLayer.SYNC_REQUEST_OBJECT);
                super.write(ctx, msg, promise);
                return;
            }
            if (msg instanceof Commands) {
                ctx.write(RakNetSimpleMultiChannelCodec.SIGNAL_START_MULTICHANNEL);
                super.write(ctx, msg, promise);
                return;
            }
        }
        super.write(ctx, msg, promise);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof PacketWrapper) {
            PacketWrapper wrapper = (PacketWrapper)msg;
            DefinedPacket definedPacket = wrapper.packet;
            if (definedPacket instanceof EncryptionResponse) {
                EncryptionResponse packet = (EncryptionResponse)definedPacket;
                try {
                    this.encryptionKey = RakNetBungeeClientChannelEventListener.getSecretUnchecked(packet);
                }
                catch (Throwable t) {
                    RaknetifyBungeePlugin.LOGGER.log(Level.WARNING, "Failed to decrypt captured encryption secret, the raknetify connection is broken", t);
                }
            }
        }
        super.channelRead(ctx, msg);
    }

    private static SecretKey getSecretUnchecked(EncryptionResponse resp) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, EncryptionUtil.keys.getPrivate());
        return new SecretKeySpec(cipher.doFinal(resp.getSharedSecret()), "AES");
    }

    public void setProtocol(Protocol protocol, int protocolVersion) {
        this.protocol = protocol;
        this.protocolVersion = protocolVersion;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
    }
}

