/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.bungee.connection;

import com.ishland.raknetify.bungee.RaknetifyBungeePlugin;
import com.ishland.raknetify.bungee.connection.RakNetBungeeClientChannelEventListener;
import com.ishland.raknetify.bungee.connection.RakNetBungeePingUpdater;
import com.ishland.raknetify.bungee.connection.RakNetBungeeServerChannelEventListener;
import com.ishland.raknetify.bungee.connection.StripFrameHandler;
import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.common.connection.RakNetConnectionUtil;
import com.ishland.raknetify.common.connection.RakNetSimpleMultiChannelCodec;
import com.ishland.raknetify.common.connection.SynchronizationLayer;
import com.ishland.raknetify.common.connection.multichannel.CustomPayloadChannel;
import com.ishland.raknetify.common.data.ProtocolMultiChannelMappings;
import com.ishland.raknetify.common.util.ReflectionUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import java.lang.reflect.Field;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.PluginMessage;
import network.ycc.raknet.RakNet;

public class RakNetBungeeConnectionUtil {
    private static final Field USER_CONNECTION_CH;
    private static final Field SERVER_CONNECTION_CH;
    private static final Field ENCODER_PROTOCOL_VERSION;

    private RakNetBungeeConnectionUtil() {
    }

    public static void initChannel(Channel channel) {
        if (channel.config() instanceof RakNet.Config) {
            RakNetConnectionUtil.initChannel(channel);
            channel.pipeline().addAfter("raknetify-multichannel-streaming-compression", "raknetify-simple-multi-channel-data-codec", (ChannelHandler)new RakNetSimpleMultiChannelCodec(253));
        }
    }

    public static void postInitChannel(Channel channel, boolean isClientSide) {
        if (channel.config() instanceof RakNet.Config) {
            channel.pipeline().replace("timeout", "timeout", (ChannelHandler)new ChannelDuplexHandler());
            channel.pipeline().replace("frame-decoder", "frame-decoder", (ChannelHandler)new ChannelDuplexHandler());
            channel.pipeline().addBefore("frame-prepender-compress", "raknetify-bungee-strip-frame", (ChannelHandler)StripFrameHandler.INSTANCE);
            if (channel.pipeline().get(HAProxyMessageDecoder.class) != null) {
                channel.pipeline().remove(HAProxyMessageDecoder.class);
            }
            channel.pipeline().addBefore("inbound-boss", "raknetify-bungee-event-listener", (ChannelHandler)new RakNetBungeeClientChannelEventListener());
        }
    }

    public static void onPlayerLogin(PostLoginEvent evt) {
        try {
            ChannelConfig channelConfig;
            UserConnection player = (UserConnection)evt.getPlayer();
            ChannelWrapper channelWrapper = (ChannelWrapper)USER_CONNECTION_CH.get(player);
            Channel channel = channelWrapper.getHandle();
            if (channel != null && (channelConfig = channel.config()) instanceof RakNet.Config) {
                RakNet.Config config = (RakNet.Config)channelConfig;
                RakNetSimpleMultiChannelCodec multiChannelCodec = (RakNetSimpleMultiChannelCodec)channel.pipeline().get(RakNetSimpleMultiChannelCodec.class);
                if (multiChannelCodec != null) {
                    int protocolVersion = (Integer)ENCODER_PROTOCOL_VERSION.get(channel.pipeline().get(MinecraftEncoder.class));
                    ProtocolMultiChannelMappings.VersionMapping versionMapping = ProtocolMultiChannelMappings.INSTANCE.mappings.get(protocolVersion);
                    if (versionMapping != null) {
                        Object directionDataToClient = ReflectionUtil.accessible(Protocol.class.getDeclaredField("TO_CLIENT")).get(Protocol.GAME);
                        int pluginMessageId = (Integer)ReflectionUtil.accessible(Class.forName("net.md_5.bungee.protocol.Protocol$DirectionData").getDeclaredMethod("getId", Class.class, Integer.TYPE)).invoke(directionDataToClient, PluginMessage.class, protocolVersion);
                        if (Constants.DEBUG) {
                            RaknetifyBungeePlugin.LOGGER.info("PluginMessage packetId=%d at version=%d".formatted(pluginMessageId, protocolVersion));
                        }
                        multiChannelCodec.addHandler(new CustomPayloadChannel.OverrideHandler(value -> value == pluginMessageId));
                        multiChannelCodec.addHandler(new RakNetSimpleMultiChannelCodec.PacketIdBasedOverrideHandler(versionMapping.s2c, "protocol version %d".formatted(protocolVersion)));
                    } else {
                        RaknetifyBungeePlugin.LOGGER.warning("No multi-channel mapping found for protocol version %d, reduced responsiveness is expected".formatted(protocolVersion));
                    }
                }
                channel.pipeline().addBefore("inbound-boss", "raknetify-bungee-ping-updater", (ChannelHandler)new RakNetBungeePingUpdater(player));
                RaknetifyBungeePlugin.LOGGER.info(String.format("Raknetify: %s logged in via RakNet, mtu %d", player.getName(), config.getMTU()));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void handleServerSwitch(ServerConnectedEvent evt) {
        try {
            ChannelConfig channelConfig;
            UserConnection player = (UserConnection)evt.getPlayer();
            Channel playerChannel = ((ChannelWrapper)USER_CONNECTION_CH.get(player)).getHandle();
            if (playerChannel != null && (channelConfig = playerChannel.config()) instanceof RakNet.Config) {
                RakNet.Config config = (RakNet.Config)channelConfig;
                playerChannel.write(SynchronizationLayer.SYNC_REQUEST_OBJECT);
                ServerConnection server = (ServerConnection)evt.getServer();
                Channel serverChannel = ((ChannelWrapper)SERVER_CONNECTION_CH.get(server)).getHandle();
                serverChannel.pipeline().addBefore("inbound-boss", "raknetify-bungee-downstream-event-listener", (ChannelHandler)new RakNetBungeeServerChannelEventListener(playerChannel));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        try {
            USER_CONNECTION_CH = ReflectionUtil.accessible(UserConnection.class.getDeclaredField("ch"));
            SERVER_CONNECTION_CH = ReflectionUtil.accessible(ServerConnection.class.getDeclaredField("ch"));
            ENCODER_PROTOCOL_VERSION = ReflectionUtil.accessible(MinecraftEncoder.class.getDeclaredField("protocolVersion"));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

