/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.bungee.connection;

import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.UserConnection;
import network.ycc.raknet.RakNet;

public class RakNetBungeePingUpdater
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-bungee-ping-updater";
    private final UserConnection player;
    ScheduledFuture<?> updateTask = null;

    public RakNetBungeePingUpdater(UserConnection player) {
        this.player = Objects.requireNonNull(player);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        ChannelConfig channelConfig = ctx.channel().config();
        if (channelConfig instanceof RakNet.Config) {
            RakNet.Config config = (RakNet.Config)channelConfig;
            this.updateTask = ctx.channel().eventLoop().scheduleAtFixedRate(() -> this.player.setPing((int)((config.getRTTNanos() + config.getRTTStdDevNanos()) / 1000000L)), 0L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.updateTask != null) {
            this.updateTask.cancel(false);
            this.updateTask = null;
        }
    }
}

