/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.bungee.connection;

import com.google.common.base.Preconditions;
import com.ishland.raknetify.bungee.RaknetifyBungeePlugin;
import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.common.connection.SynchronizationLayer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Respawn;
import network.ycc.raknet.RakNet;

public class RakNetBungeeServerChannelEventListener
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-bungee-downstream-event-listener";
    private final Channel clientChannel;

    public RakNetBungeeServerChannelEventListener(Channel clientChannel) {
        Preconditions.checkArgument((boolean)(clientChannel.config() instanceof RakNet.Config));
        this.clientChannel = clientChannel;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof PacketWrapper) {
            PacketWrapper wrapper = (PacketWrapper)msg;
            DefinedPacket packet = wrapper.packet;
            if (packet instanceof Respawn) {
                this.clientChannel.write(SynchronizationLayer.SYNC_REQUEST_OBJECT);
            } else if (packet instanceof KeepAlive) {
                if (Constants.DEBUG) {
                    RaknetifyBungeePlugin.LOGGER.info("Received downstream keepalive, swallowing it");
                }
                long rttNanos = RakNet.config(this.clientChannel).getRTTNanos();
                ctx.channel().eventLoop().schedule(() -> ctx.writeAndFlush((Object)packet), Math.max(rttNanos - 4000000L, 0L), TimeUnit.NANOSECONDS);
                return;
            }
        }
        super.channelRead(ctx, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
        for (Map.Entry entry : ctx.channel().pipeline().toMap().entrySet()) {
            System.out.println("%s: %s".formatted(entry.getKey(), ((ChannelHandler)entry.getValue()).getClass().getName()));
        }
    }
}

