/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.bungee.init;

import com.ishland.raknetify.bungee.RaknetifyBungeePlugin;
import com.ishland.raknetify.bungee.connection.RakNetBungeeConnectionUtil;
import com.ishland.raknetify.bungee.init.InjectedSet;
import com.ishland.raknetify.common.util.NetworkInterfaceListener;
import com.ishland.raknetify.common.util.ReflectionUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.ReflectiveChannelFactory;
import io.netty.channel.socket.DatagramChannel;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.query.QueryHandler;
import network.ycc.raknet.server.channel.RakNetServerChannel;

public class BungeeRaknetifyServer {
    private static final int portOverride = Integer.getInteger("raknetify.bungee.portOverride", -1);
    private static final Method INIT_CHANNEL;
    private static final Field BUNGEE_LISTENERS_FIELD;
    private static final Class<?> ACCEPTOR_CLASS;
    private static final Reference2ReferenceOpenHashMap<Channel, ReferenceOpenHashSet<ChannelFuture>> channels;
    private static final ReferenceOpenHashSet<ChannelFuture> nonWildcardChannels;
    private static volatile boolean active;
    private static volatile int activeIndex;
    private static boolean injected;
    private static volatile Consumer<NetworkInterfaceListener.InterfaceAddressChangeEvent> listener;

    public static void inject() {
        if (active) {
            return;
        }
        try {
            active = true;
            BungeeCord instance = (BungeeCord)ProxyServer.getInstance();
            Set listeners = (Set)BUNGEE_LISTENERS_FIELD.get(instance);
            if (!injected) {
                BUNGEE_LISTENERS_FIELD.set(instance, (Object)new InjectedSet(listeners));
                injected = true;
            }
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            for (Channel listener : listeners) {
                try {
                    BungeeRaknetifyServer.injectChannel(instance, listener, true);
                }
                catch (Throwable t) {
                    errors.add(t);
                }
            }
            int currentActiveIndex = ++activeIndex;
            listener = event -> {
                if (!active) {
                    NetworkInterfaceListener.removeListener(listener);
                }
                if (currentActiveIndex != activeIndex) {
                    return;
                }
                if (event.added()) {
                    for (Channel channel : channels.keySet()) {
                        BungeeRaknetifyServer.injectChannel(instance, channel, false);
                    }
                } else {
                    for (ReferenceOpenHashSet futures : channels.values()) {
                        Iterator iterator = futures.iterator();
                        while (iterator.hasNext()) {
                            ChannelFuture future = (ChannelFuture)iterator.next();
                            if (!((InetSocketAddress)future.channel().localAddress()).getAddress().equals(event.address())) continue;
                            RaknetifyBungeePlugin.LOGGER.info("Closing Raknetify server %s".formatted(future.channel().localAddress()));
                            future.channel().close();
                            iterator.remove();
                        }
                    }
                }
            };
            NetworkInterfaceListener.addListener(event -> instance.getScheduler().schedule((Plugin)RaknetifyBungeePlugin.INSTANCE, () -> listener.accept((NetworkInterfaceListener.InterfaceAddressChangeEvent)event), 100L, TimeUnit.MILLISECONDS));
            if (!errors.isEmpty()) {
                RuntimeException exception = new RuntimeException("Failed to start Raknetify server");
                errors.forEach(exception::addSuppressed);
                throw exception;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to start Raknetify server", t);
        }
    }

    public static void injectChannel(BungeeCord instance, Channel listener, boolean throwErrors) {
        try {
            boolean hasPortOverride;
            if (!active) {
                return;
            }
            boolean bl = hasPortOverride = portOverride > 0 && portOverride < 65535;
            if (hasPortOverride && !channels.isEmpty()) {
                return;
            }
            if (!(listener.localAddress() instanceof InetSocketAddress)) {
                return;
            }
            ChannelInitializer initializer = null;
            ListenerInfo info = null;
            for (String name : listener.pipeline().names()) {
                ChannelHandler handler = listener.pipeline().get(name);
                if (handler instanceof QueryHandler) {
                    return;
                }
                if (handler == null || !ACCEPTOR_CLASS.isAssignableFrom(handler.getClass())) continue;
                try {
                    Map.Entry[] attrs;
                    initializer = (ChannelInitializer)ReflectionUtil.accessible(ACCEPTOR_CLASS.getDeclaredField("childHandler")).get(handler);
                    for (Map.Entry attr : attrs = (Map.Entry[])ReflectionUtil.accessible(ACCEPTOR_CLASS.getDeclaredField("childAttrs")).get(handler)) {
                        if (attr.getKey() != PipelineUtils.LISTENER) continue;
                        info = (ListenerInfo)attr.getValue();
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
            }
            if (initializer == null) {
                RaknetifyBungeePlugin.LOGGER.severe("Unable to find channel initializer for listener %s".formatted(listener));
                return;
            }
            if (info == null) {
                RaknetifyBungeePlugin.LOGGER.severe("Unable to find listener info for listener %s".formatted(listener));
                return;
            }
            if (listener.getClass().getName().startsWith("org.geysermc.geyser.network")) {
                return;
            }
            if (((InetSocketAddress)info.getSocketAddress()).getAddress().isAnyLocalAddress()) {
                for (NetworkInterface networkInterface : NetworkInterface.networkInterfaces().toList()) {
                    Iterator<InetAddress> iterator = networkInterface.getInetAddresses().asIterator();
                    while (iterator.hasNext()) {
                        InetAddress address = iterator.next();
                        try {
                            BungeeRaknetifyServer.startServer(instance, listener, (ChannelInitializer<Channel>)initializer, info, address);
                        }
                        catch (Throwable t) {
                            RaknetifyBungeePlugin.LOGGER.log(Level.SEVERE, "Failed to start Raknetify server", t);
                        }
                    }
                }
            } else {
                BungeeRaknetifyServer.startServer(instance, listener, initializer, info, null);
            }
        }
        catch (Throwable t) {
            if (throwErrors) {
                throw new RuntimeException("Failed to start Raknetify server", t);
            }
            RaknetifyBungeePlugin.LOGGER.log(Level.SEVERE, "Failed to start Raknetify server", t);
        }
    }

    private static void startServer(BungeeCord instance, Channel listener, final ChannelInitializer<Channel> initializer, ListenerInfo info, InetAddress address) throws NoSuchFieldException, IllegalAccessException {
        ReferenceOpenHashSet<ChannelFuture> futures;
        if (address != null && (futures = channels.get(listener)) != null) {
            for (ChannelFuture future : futures) {
                if (!((InetSocketAddress)future.channel().localAddress()).getAddress().equals(address)) continue;
                return;
            }
        }
        boolean hasPortOverride = portOverride > 0 && portOverride < 65535;
        ReflectiveChannelFactory factory = new ReflectiveChannelFactory(PipelineUtils.getDatagramChannel());
        InetAddress actualAddress = address == null ? ((InetSocketAddress)info.getSocketAddress()).getAddress() : address;
        ChannelFuture future = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channelFactory(() -> new RakNetServerChannel(() -> {
            DatagramChannel channel = (DatagramChannel)factory.newChannel();
            channel.config().setOption(ChannelOption.IP_TOS, (Object)24);
            channel.config().setRecvByteBufAllocator((RecvByteBufAllocator)new FixedRecvByteBufAllocator(8704).maxMessagesPerRead(128));
            return channel;
        }))).option(ChannelOption.SO_REUSEADDR, (Object)true)).childAttr(PipelineUtils.LISTENER, (Object)info).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) throws Exception {
                RakNetBungeeConnectionUtil.initChannel(channel);
                INIT_CHANNEL.invoke((Object)initializer, channel);
                RakNetBungeeConnectionUtil.postInitChannel(channel, false);
            }
        }).group(BungeeRaknetifyServer.getBossEventLoopGroup(instance), BungeeRaknetifyServer.getWorkerEventLoopGroup(instance)).localAddress((SocketAddress)(hasPortOverride ? new InetSocketAddress(actualAddress, portOverride) : new InetSocketAddress(actualAddress, ((InetSocketAddress)info.getSocketAddress()).getPort())))).bind().syncUninterruptibly();
        if (address == null) {
            nonWildcardChannels.add(future);
        } else {
            channels.computeIfAbsent(listener, unused -> new ReferenceOpenHashSet()).add(future);
        }
        RaknetifyBungeePlugin.LOGGER.info("Raknetify server started on %s".formatted(future.channel().localAddress()));
    }

    public static void stopAll() {
        if (!active) {
            return;
        }
        for (ChannelFuture future : Stream.concat(channels.values().stream().flatMap(Collection::stream), nonWildcardChannels.stream()).toList()) {
            RaknetifyBungeePlugin.LOGGER.info("Closing Raknetify server %s".formatted(future.channel().localAddress()));
            try {
                future.channel().close().sync();
            }
            catch (InterruptedException e) {
                RaknetifyBungeePlugin.LOGGER.severe("Interrupted whilst closing raknetify server");
            }
        }
        channels.clear();
        nonWildcardChannels.clear();
    }

    public static void disable() {
        if (!active) {
            return;
        }
        BungeeRaknetifyServer.stopAll();
        active = false;
    }

    private static EventLoopGroup getBossEventLoopGroup(BungeeCord instance) throws NoSuchFieldException, IllegalAccessException {
        try {
            return (EventLoopGroup)ReflectionUtil.accessible(BungeeCord.class.getDeclaredField("eventLoops")).get(instance);
        }
        catch (NoSuchFieldException e) {
            return (EventLoopGroup)ReflectionUtil.accessible(BungeeCord.class.getDeclaredField("bossEventLoopGroup")).get(instance);
        }
    }

    private static EventLoopGroup getWorkerEventLoopGroup(BungeeCord instance) throws NoSuchFieldException, IllegalAccessException {
        try {
            return (EventLoopGroup)ReflectionUtil.accessible(BungeeCord.class.getDeclaredField("eventLoops")).get(instance);
        }
        catch (NoSuchFieldException e) {
            return (EventLoopGroup)ReflectionUtil.accessible(BungeeCord.class.getDeclaredField("workerEventLoopGroup")).get(instance);
        }
    }

    static {
        try {
            INIT_CHANNEL = ReflectionUtil.accessible(ChannelInitializer.class.getDeclaredMethod("initChannel", Channel.class));
            BUNGEE_LISTENERS_FIELD = ReflectionUtil.accessible(BungeeCord.class.getDeclaredField("listeners"));
            ACCEPTOR_CLASS = Class.forName("io.netty.bootstrap.ServerBootstrap$ServerBootstrapAcceptor");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        channels = new Reference2ReferenceOpenHashMap();
        nonWildcardChannels = new ReferenceOpenHashSet();
        active = false;
        activeIndex = 0;
        injected = false;
        listener = null;
    }
}

