/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.connection;

import com.ishland.raknetify.common.connection.PacketEncryptionManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import network.ycc.raknet.frame.FrameData;

public class MultiChannellingEncryption
extends ChannelDuplexHandler {
    public static final String NAME = "raknetify-multichannel-encryption";
    private final PacketEncryptionManager decryption;
    private final PacketEncryptionManager encryption;

    public MultiChannellingEncryption(SecretKey key) throws GeneralSecurityException {
        Cipher decryption = Cipher.getInstance("AES/CFB8/NoPadding");
        decryption.init(2, (Key)key, new IvParameterSpec(key.getEncoded()));
        this.decryption = new PacketEncryptionManager(decryption);
        Cipher encryption = Cipher.getInstance("AES/CFB8/NoPadding");
        encryption.init(1, (Key)key, new IvParameterSpec(key.getEncoded()));
        this.encryption = new PacketEncryptionManager(encryption);
    }

    public MultiChannellingEncryption(Cipher decryption, Cipher encryption) {
        this.decryption = new PacketEncryptionManager(Objects.requireNonNull(decryption));
        this.encryption = new PacketEncryptionManager(Objects.requireNonNull(encryption));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof FrameData) {
            FrameData data = (FrameData)msg;
            data.touch();
            ByteBuf buf = data.createData().skipBytes(1);
            ByteBuf res = null;
            FrameData resFrame = null;
            try {
                res = ctx.alloc().buffer(data.getDataSize());
                this.encryption.doWork(buf, res);
                resFrame = FrameData.create(ctx.alloc(), data.getPacketId(), res);
                resFrame.setOrderChannel(data.getOrderChannel());
                resFrame.setReliability(data.getReliability());
                ctx.write((Object)resFrame, promise);
                resFrame = null;
                return;
            }
            finally {
                buf.release();
                data.release();
                if (res != null) {
                    res.release();
                }
                if (resFrame != null) {
                    resFrame.release();
                }
            }
        }
        super.write(ctx, msg, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FrameData) {
            FrameData data = (FrameData)msg;
            data.touch();
            ByteBuf buf = data.createData().skipBytes(1);
            ByteBuf res = null;
            FrameData resFrame = null;
            try {
                res = ctx.alloc().buffer(data.getDataSize());
                this.decryption.doWork(buf, res);
                resFrame = FrameData.create(ctx.alloc(), data.getPacketId(), res);
                resFrame.setOrderChannel(data.getOrderChannel());
                resFrame.setReliability(data.getReliability());
                ctx.fireChannelRead((Object)resFrame);
                resFrame = null;
                return;
            }
            finally {
                buf.release();
                data.release();
                if (res != null) {
                    res.release();
                }
                if (resFrame != null) {
                    resFrame.release();
                }
            }
        }
        super.channelRead(ctx, msg);
    }
}

