/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.connection;

import com.ishland.raknetify.common.Constants;
import com.ishland.raknetify.common.connection.FrameDataBlocker;
import com.ishland.raknetify.common.connection.MetricsSynchronizationHandler;
import com.ishland.raknetify.common.connection.MultiChannelingStreamingCompression;
import com.ishland.raknetify.common.connection.NoFlush;
import com.ishland.raknetify.common.connection.SimpleMetricsLogger;
import com.ishland.raknetify.common.connection.SynchronizationLayer;
import com.ishland.raknetify.common.util.ReflectionUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.client.channel.RakNetClientThreadedChannel;
import network.ycc.raknet.frame.Frame;
import network.ycc.raknet.pipeline.ReliabilityHandler;
import network.ycc.raknet.server.channel.RakNetApplicationChannel;

public class RakNetConnectionUtil {
    public static final int IP_TOS_LOWDELAY = 16;
    public static final int IP_TOS_THROUGHPUT = 8;
    public static final int IP_TOS_RELIABILITY = 4;
    public static final int DEFAULT_IP_TOS = 24;
    private static final Comparator<Frame> cmp = Comparator.comparingInt(frame -> frame.getReliability().isReliable ? 1 : 0).thenComparingInt(frame -> frame.getReliability().isOrdered ? 1 : 0).thenComparingInt(Frame::getOrderChannel).thenComparingInt(Frame::getOrderIndex);

    private RakNetConnectionUtil() {
    }

    public static void initChannel(Channel channel) {
        ChannelConfig channelConfig = channel.config();
        if (channelConfig instanceof RakNet.Config) {
            RakNet.Config config = (RakNet.Config)channelConfig;
            config.setMaxQueuedBytes(0x10000000);
            config.setMaxPendingFrameSets(512);
            config.setRetryDelayNanos(TimeUnit.NANOSECONDS.convert(50L, TimeUnit.MILLISECONDS));
            config.setDefaultPendingFrameSets(4);
            config.setNACKEnabled(false);
            config.setNoDelayEnabled(false);
            RakNetConnectionUtil.initRaknetChannel(channel);
            channel.pipeline().addLast("raknetify-no-flush", (ChannelHandler)new NoFlush());
            channel.pipeline().addLast("raknetify-multichannel-streaming-compression", (ChannelHandler)new MultiChannelingStreamingCompression(253, 237));
            channel.pipeline().addLast("raknetify-frame-data-blocker", (ChannelHandler)new FrameDataBlocker());
        }
    }

    private static void initRaknetChannel(Channel appChannel) {
        String threadedReadHandlerName;
        Channel channel;
        if (appChannel instanceof RakNetApplicationChannel) {
            channel = appChannel.parent();
            threadedReadHandlerName = "rn-server-parent-threaded-read-handler";
        } else if (appChannel instanceof RakNetClientThreadedChannel) {
            channel = appChannel.parent();
            threadedReadHandlerName = "rn-client-parent-threaded-read-handler";
        } else {
            channel = appChannel;
            threadedReadHandlerName = null;
        }
        channel.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                RakNet.Config config = (RakNet.Config)ch.config();
                SimpleMetricsLogger simpleMetricsLogger = new SimpleMetricsLogger();
                config.setMetrics(simpleMetricsLogger);
                MetricsSynchronizationHandler metricsSynchronizationHandler = new MetricsSynchronizationHandler();
                simpleMetricsLogger.setMetricsSynchronizationHandler(metricsSynchronizationHandler);
                SynchronizationLayer synchronizationLayer = new SynchronizationLayer(Constants.SYNC_IGNORE_CHANNELS);
                RakNetConnectionUtil.reInitChannelForOrdering(channel);
                if (threadedReadHandlerName != null) {
                    ch.pipeline().addBefore(threadedReadHandlerName, "raknetify-metrics-sync", (ChannelHandler)metricsSynchronizationHandler);
                    ch.pipeline().addBefore(threadedReadHandlerName, "raknetify-synchronization-layer", (ChannelHandler)synchronizationLayer);
                } else {
                    ch.pipeline().addLast("raknetify-metrics-sync", (ChannelHandler)metricsSynchronizationHandler);
                    ch.pipeline().addLast("raknetify-synchronization-layer", (ChannelHandler)synchronizationLayer);
                }
                ch.pipeline().addFirst("raknetify-timeout", (ChannelHandler)new ReadTimeoutHandler(15));
            }
        }});
    }

    private static void reInitChannelForOrdering(Channel channel) {
        ChannelConfig channelConfig = channel.config();
        if (channelConfig instanceof RakNet.Config) {
            RakNet.Config config = (RakNet.Config)channelConfig;
            try {
                ReliabilityHandler reliabilityHandler = (ReliabilityHandler)channel.pipeline().get(ReliabilityHandler.class);
                Field frameQueueField = ReflectionUtil.accessible(ReliabilityHandler.class.getDeclaredField("frameQueue"));
                PriorityQueue reliabilityHandlerFrameQueue = (PriorityQueue)frameQueueField.get((Object)reliabilityHandler);
                PriorityQueue<Frame> newSet = new PriorityQueue<Frame>(cmp);
                newSet.addAll(reliabilityHandlerFrameQueue);
                frameQueueField.set((Object)reliabilityHandler, newSet);
            }
            catch (Throwable t) {
                System.err.println("Raknetify: Error occurred while reinitializing channel ordering");
                t.printStackTrace();
            }
        }
    }
}

