/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.client.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.socket.DatagramChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.net.SocketAddress;
import java.util.function.Supplier;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.client.channel.RakNetClientChannel;

public class RakNetClientThreadedChannel
extends AbstractChannel {
    public static final String NAME_CLIENT_PARENT_THREADED_READ_HANDLER = "rn-client-parent-threaded-read-handler";
    private EventLoop providedParentEventLoop = null;
    private EventLoop pendingEventLoop = null;
    private volatile boolean active = false;

    public RakNetClientThreadedChannel() {
        super((Channel)new RakNetClientChannel());
        this.setupDefaultPipeline();
    }

    public RakNetClientThreadedChannel(Class<? extends DatagramChannel> ioChannelType) {
        super((Channel)new RakNetClientChannel(ioChannelType));
        this.setupDefaultPipeline();
    }

    public RakNetClientThreadedChannel(Supplier<? extends DatagramChannel> ioChannelSupplier) {
        super((Channel)new RakNetClientChannel(ioChannelSupplier));
        this.setupDefaultPipeline();
    }

    @Deprecated
    public void setProvidedEventLoop(EventLoop providedEventLoop) {
        this.setProvidedParentEventLoop(providedEventLoop);
    }

    public void setProvidedParentEventLoop(EventLoop providedParentEventLoop) {
        this.providedParentEventLoop = providedParentEventLoop;
    }

    private void setupDefaultPipeline() {
        this.parent().pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast(RakNetClientThreadedChannel.NAME_CLIENT_PARENT_THREADED_READ_HANDLER, (ChannelHandler)new ParentReadHandler());
            }
        }});
    }

    public boolean isWritable() {
        Boolean result = (Boolean)this.attr(RakNet.WRITABLE).get();
        return (result == null || result != false) && this.parent().isWritable();
    }

    public long bytesBeforeUnwritable() {
        return this.parent().bytesBeforeUnwritable();
    }

    public long bytesBeforeWritable() {
        return this.parent().bytesBeforeWritable();
    }

    public RakNetClientChannel parent() {
        return (RakNetClientChannel)super.parent();
    }

    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new RakNetClientThreadedChannelUnsafe();
    }

    public Channel.Unsafe unsafe() {
        return ((RakNetClientThreadedChannelUnsafe)super.unsafe()).wrapped;
    }

    protected boolean isCompatible(EventLoop eventloop) {
        this.pendingEventLoop = eventloop;
        return true;
    }

    protected SocketAddress localAddress0() {
        return this.parent().localAddress();
    }

    protected SocketAddress remoteAddress0() {
        return this.parent().remoteAddress();
    }

    protected void doBind(SocketAddress addr) {
        throw new UnsupportedOperationException();
    }

    protected void doDisconnect() {
        this.active = false;
        this.parent().close();
    }

    protected void doClose() {
        this.active = false;
        this.parent().close();
    }

    protected void doBeginRead() {
    }

    protected void doWrite(ChannelOutboundBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public RakNet.Config config() {
        return this.parent().config();
    }

    public boolean isOpen() {
        return this.parent().isOpen();
    }

    public boolean isActive() {
        return this.active;
    }

    public ChannelMetadata metadata() {
        return this.parent().metadata();
    }

    private void registerParent() {
        if (!this.parent().isRegistered()) {
            EventLoop loop;
            EventLoop eventLoop = loop = this.providedParentEventLoop != null ? this.providedParentEventLoop : this.pendingEventLoop;
            if (loop == null) {
                throw new IllegalStateException("channel not registered");
            }
            loop.register((Channel)this.parent());
        }
    }

    protected final class RakNetClientThreadedChannelUnsafe
    extends AbstractChannel.AbstractUnsafe {
        final Channel.Unsafe wrapped;

        protected RakNetClientThreadedChannelUnsafe() {
            super((AbstractChannel)RakNetClientThreadedChannel.this);
            this.wrapped = new Channel.Unsafe(){

                public RecvByteBufAllocator.Handle recvBufAllocHandle() {
                    return RakNetClientThreadedChannelUnsafe.this.recvBufAllocHandle();
                }

                public SocketAddress localAddress() {
                    return RakNetClientThreadedChannelUnsafe.this.localAddress();
                }

                public SocketAddress remoteAddress() {
                    return RakNetClientThreadedChannelUnsafe.this.remoteAddress();
                }

                public void register(EventLoop eventLoop, ChannelPromise promise) {
                    RakNetClientThreadedChannelUnsafe.this.register(eventLoop, promise);
                }

                public void bind(SocketAddress localAddress, ChannelPromise promise) {
                    RakNetClientThreadedChannel.this.registerParent();
                    ChannelFuture future = RakNetClientThreadedChannel.this.parent().bind(localAddress);
                    future.addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                    future.addListener(future1 -> {
                        if (future1.isSuccess()) {
                            promise.trySuccess();
                        } else {
                            promise.tryFailure(future1.cause());
                        }
                    });
                }

                public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                    RakNetClientThreadedChannelUnsafe.this.connect(remoteAddress, localAddress, promise);
                }

                public void disconnect(ChannelPromise promise) {
                    RakNetClientThreadedChannelUnsafe.this.disconnect(promise);
                }

                public void close(ChannelPromise promise) {
                    EventLoop parentEventLoop = RakNetClientThreadedChannel.this.parent().eventLoop();
                    RakNetClientThreadedChannel.this.parent().close().addListener(future -> {
                        PromiseCombiner combiner = new PromiseCombiner();
                        ChannelPromise newPromise = promise.channel().newPromise();
                        parentEventLoop.execute(() -> promise.channel().eventLoop().execute(() -> RakNetClientThreadedChannelUnsafe.this.close(newPromise)));
                        combiner.add((Future)newPromise);
                        combiner.add(future);
                        combiner.finish((Promise)promise);
                    });
                }

                public void closeForcibly() {
                    RakNetClientThreadedChannelUnsafe.this.closeForcibly();
                }

                public void deregister(ChannelPromise promise) {
                    RakNetClientThreadedChannelUnsafe.this.deregister(promise);
                }

                public void beginRead() {
                    RakNetClientThreadedChannelUnsafe.this.beginRead();
                }

                public void write(Object msg, ChannelPromise promise) {
                    ChannelFuture future = RakNetClientThreadedChannel.this.parent().write(msg);
                    future.addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                    future.addListener(future1 -> {
                        if (future1.isSuccess()) {
                            promise.trySuccess();
                        } else {
                            promise.tryFailure(future1.cause());
                        }
                    });
                }

                public void flush() {
                    RakNetClientThreadedChannel.this.parent().flush();
                }

                public ChannelPromise voidPromise() {
                    return RakNetClientThreadedChannelUnsafe.this.voidPromise();
                }

                public ChannelOutboundBuffer outboundBuffer() {
                    return RakNetClientThreadedChannelUnsafe.this.outboundBuffer();
                }
            };
        }

        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            RakNetClientThreadedChannel.this.registerParent();
            ChannelFuture future = RakNetClientThreadedChannel.this.parent().connect(remoteAddress, localAddress);
            future.addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
            future.addListener(future1 -> {
                if (future1.isSuccess()) {
                    promise.trySuccess();
                } else {
                    promise.tryFailure(future1.cause());
                }
            });
        }
    }

    protected class ParentReadHandler
    extends ChannelInboundHandlerAdapter {
        protected ParentReadHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.eventLoop().execute(() -> {
                RakNetClientThreadedChannel.this.active = true;
                RakNetClientThreadedChannel.this.pipeline().fireChannelActive();
            });
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.eventLoop().execute(() -> {
                RakNetClientThreadedChannel.this.active = false;
                RakNetClientThreadedChannel.this.pipeline().fireChannelInactive();
            });
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            RakNetClientThreadedChannel.this.pipeline().fireChannelRead(msg);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.pipeline().fireChannelReadComplete();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            RakNetClientThreadedChannel.this.pipeline().fireUserEventTriggered(evt);
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            RakNetClientThreadedChannel.this.pipeline().fireChannelWritabilityChanged();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            RakNetClientThreadedChannel.this.pipeline().fireExceptionCaught(cause);
        }
    }
}

