/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.packet.SimpleFramedPacket;

public class ClientHandshake
extends SimpleFramedPacket {
    private long pongTimestamp;
    private long timestamp;
    private InetSocketAddress address;
    private int nExtraAddresses;

    public ClientHandshake() {
        this.reliability = FramedPacket.Reliability.RELIABLE_ORDERED;
    }

    public ClientHandshake(long pongTimestamp, InetSocketAddress address, int nExtraAddresses) {
        this(pongTimestamp, System.nanoTime(), address, nExtraAddresses);
    }

    public ClientHandshake(long pongTimestamp, long timestamp, InetSocketAddress address, int nExtraAddresses) {
        this();
        this.pongTimestamp = pongTimestamp;
        this.timestamp = timestamp;
        this.address = address;
        this.nExtraAddresses = nExtraAddresses;
    }

    @Override
    public void encode(ByteBuf buf) {
        ClientHandshake.writeAddress(buf, this.address);
        for (int i = 0; i < this.nExtraAddresses; ++i) {
            ClientHandshake.writeAddress(buf);
        }
        buf.writeLong(this.pongTimestamp);
        buf.writeLong(this.timestamp);
    }

    @Override
    public void decode(ByteBuf buf) {
        this.address = ClientHandshake.readAddress(buf);
        this.nExtraAddresses = 0;
        while (buf.readableBytes() > 16) {
            ClientHandshake.readAddress(buf);
            ++this.nExtraAddresses;
        }
        this.pongTimestamp = buf.readLong();
        this.timestamp = buf.readLong();
    }

    public long getPongTimestamp() {
        return this.pongTimestamp;
    }

    public void setPongTimestamp(long pongTimestamp) {
        this.pongTimestamp = pongTimestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getnExtraAddresses() {
        return this.nExtraAddresses;
    }

    public void setnExtraAddresses(int nExtraAddresses) {
        this.nExtraAddresses = nExtraAddresses;
    }
}

