/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.config.DefaultMagic;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.packet.SimplePacket;

public class InvalidVersion
extends SimplePacket
implements Packet {
    private RakNet.Magic magic;
    private int version;
    private long serverId;

    public InvalidVersion() {
    }

    public InvalidVersion(RakNet.Magic magic, long serverId) {
        this.magic = magic;
        this.serverId = serverId;
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeByte(this.version);
        this.magic.write(buf);
        buf.writeLong(this.serverId);
    }

    @Override
    public void decode(ByteBuf buf) {
        this.version = buf.readUnsignedByte();
        this.magic = DefaultMagic.decode(buf);
        this.serverId = buf.readLong();
    }

    public RakNet.Magic getMagic() {
        return this.magic;
    }

    public void setMagic(RakNet.Magic magic) {
        this.magic = magic;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    public static class InvalidVersionException
    extends DecoderException {
        public static final long serialVersionUID = 590681756L;

        public InvalidVersionException() {
            super("Incorrect RakNet version");
        }
    }
}

