/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.packet;

import io.netty.buffer.ByteBuf;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.packet.SimpleFramedPacket;

public class Pong
extends SimpleFramedPacket {
    private long pingTimestamp;
    private long pongTimestamp;

    public Pong() {
        this.reliability = FramedPacket.Reliability.UNRELIABLE;
    }

    public Pong(long pingTimestamp, FramedPacket.Reliability reliability) {
        this(pingTimestamp);
        this.reliability = reliability;
    }

    public Pong(long pingTimestamp) {
        this();
        this.pingTimestamp = pingTimestamp;
        this.pongTimestamp = System.nanoTime();
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.pingTimestamp);
        buf.writeLong(this.pongTimestamp);
    }

    @Override
    public void decode(ByteBuf buf) {
        this.pingTimestamp = buf.readLong();
        if (buf.isReadable()) {
            this.pongTimestamp = buf.readLong();
        }
    }

    public long getPingTimestamp() {
        return this.pingTimestamp;
    }

    public long getPongTimestamp() {
        return this.pongTimestamp;
    }

    public long getRTT() {
        return System.nanoTime() - this.pingTimestamp;
    }
}

