/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.util;

import com.ishland.raknetify.common.connection.MetricsSynchronizationHandler;
import com.ishland.raknetify.common.connection.MultiChannelingStreamingCompression;
import com.ishland.raknetify.common.connection.SimpleMetricsLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelHandler;
import network.ycc.raknet.RakNet;

public class DebugUtil {
    public static String printChannelDetails(Channel channel) {
        StringBuilder b = new StringBuilder();
        b.append("Channel details for ").append(channel.toString()).append(' ').append('(').append(channel.getClass().getName()).append(')').append('\n');
        b.append("Connection: ").append(channel.localAddress()).append(" <--> ").append(channel.remoteAddress()).append('\n');
        b.append("Open: ").append(channel.isOpen()).append('\n');
        b.append("Active: ").append(channel.isActive()).append('\n');
        b.append("Auto Read: ").append(channel.config().isAutoRead()).append('\n');
        ChannelConfig channelConfig = channel.config();
        if (channelConfig instanceof RakNet.Config) {
            RakNet.Config config = (RakNet.Config)channelConfig;
            b.append("MTU: ").append(config.getMTU()).append('\n');
            b.append("RTT: %.2f/%.2fms".formatted((double)config.getRTTNanos() / 1000000.0, (double)config.getRTTStdDevNanos() / 1000000.0)).append('\n');
            RakNet.MetricsLogger metricsLogger = config.getMetrics();
            if (metricsLogger instanceof SimpleMetricsLogger) {
                MultiChannelingStreamingCompression compression;
                SimpleMetricsLogger logger = (SimpleMetricsLogger)metricsLogger;
                MetricsSynchronizationHandler sync = logger.getMetricsSynchronizationHandler();
                if (sync != null && sync.isRemoteSupported()) {
                    b.append("Local Buffer: %.2fMB; Remote buffer: %.2fMB".formatted((double)logger.getCurrentQueuedBytes() / 1024.0 / 1024.0, (double)sync.getQueuedBytes() / 1024.0 / 1024.0)).append('\n');
                } else {
                    b.append("Local buffer: %.2fMB".formatted((double)logger.getCurrentQueuedBytes() / 1024.0 / 1024.0)).append('\n');
                }
                b.append("Local traffic: I: %s, O: %s".formatted(logger.getMeasureTrafficInFormatted(), logger.getMeasureTrafficOutFormatted())).append('\n');
                b.append("Local Statistics: ERR: %.4f%%, %d tx, %d rx, Burst: %d".formatted(logger.getMeasureErrorRate() * 100.0, logger.getMeasureTX(), logger.getMeasureRX(), logger.getMeasureBurstTokens() + (long)config.getDefaultPendingFrameSets())).append('\n');
                if (sync != null && sync.isRemoteSupported()) {
                    b.append("Remote Statistics: ERR: %.4f%%, %d tx, %d rx, Burst: %d".formatted(sync.getErrorRate() * 100.0, sync.getTX(), sync.getRX(), sync.getBurst())).append('\n');
                }
                if ((compression = (MultiChannelingStreamingCompression)channel.pipeline().get(MultiChannelingStreamingCompression.class)) != null && compression.isActive()) {
                    b.append("Local Streaming Compression Ratio: I: %.2f%%, O: %.2f%%".formatted(compression.getInCompressionRatio() * 100.0, compression.getOutCompressionRatio() * 100.0)).append('\n');
                }
            }
        }
        b.append('\n');
        b.append("Pipeline: ").append('\n');
        for (String name : channel.pipeline().names()) {
            ChannelHandler channelHandler = channel.pipeline().get(name);
            if (channelHandler == null) {
                b.append("\t").append(name).append(": \t").append("null").append('\n');
                continue;
            }
            b.append("\t").append(name).append(": \t").append(channelHandler.toString()).append("(").append(channelHandler.getClass().getName()).append(")").append('\n');
        }
        if (channel.parent() != null) {
            b.append('\n');
            b.append("Parent: ").append('\n');
            b.append(DebugUtil.printChannelDetails(channel.parent()).replace("\n", "\n\t"));
        }
        return b.toString();
    }
}

