/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.common.util;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.text.StringCharacterIterator;

public class MathUtil {
    public static String humanReadableByteCountBin(long bytes) {
        long absB;
        long l = absB = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absB < 1024L) {
            return bytes + " B";
        }
        long value = absB;
        StringCharacterIterator ci = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && absB > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            value >>= 10;
            ci.next();
        }
        return String.format("%.2f %ciB", (double)(value *= (long)Long.signum(bytes)) / 1024.0, Character.valueOf(ci.current()));
    }

    public static int readVarInt(ByteBuf buf) {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = buf.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    public static String readString(ByteBuf buf) {
        return MathUtil.readString(buf, Short.MAX_VALUE);
    }

    public static String readString(ByteBuf buf, int maxLen) {
        int len = MathUtil.readVarInt(buf);
        if (len > maxLen * 3) {
            throw new IllegalArgumentException("Cannot receive string longer than " + maxLen * 3 + " (got " + len + " bytes)");
        }
        String s = buf.toString(buf.readerIndex(), len, Charsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + len);
        if (s.length() > maxLen) {
            throw new IllegalArgumentException("Cannot receive string longer than " + maxLen + " (got " + s.length() + " characters)");
        }
        return s;
    }
}

