/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.raknetify.fabric.common.client;

import com.ishland.raknetify.common.connection.MetricsSynchronizationHandler;
import com.ishland.raknetify.common.connection.MultiChannelingStreamingCompression;
import com.ishland.raknetify.common.connection.SimpleMetricsLogger;
import com.ishland.raknetify.fabric.common.util.MultiVersionUtil;
import com.ishland.raknetify.fabric.mixin.access.IClientConnection;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import java.util.function.Consumer;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_634;
import network.ycc.raknet.RakNet;

public class DebugHudUtil {
    public static void getDebugString(Consumer<String> consumer) {
        ChannelConfig channelConfig;
        class_2535 connection;
        Channel channel;
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler != null && (channel = ((IClientConnection)(connection = MultiVersionUtil.ClientPlayNetworkHandler$connection.get(networkHandler))).getChannel()) != null && (channelConfig = channel.config()) instanceof RakNet.Config) {
            RakNet.Config config = (RakNet.Config)channelConfig;
            RakNet.MetricsLogger metricsLogger = config.getMetrics();
            if (metricsLogger instanceof SimpleMetricsLogger) {
                SimpleMetricsLogger logger = (SimpleMetricsLogger)metricsLogger;
                consumer.accept("[Raknetify] A: true, MTU: %d, RTT: %.2f/%.2fms".formatted(config.getMTU(), (double)logger.getMeasureRTTns() / 1000000.0, (double)logger.getMeasureRTTnsStdDev() / 1000000.0));
                MetricsSynchronizationHandler serverSync = logger.getMetricsSynchronizationHandler();
                if (serverSync != null && serverSync.isRemoteSupported()) {
                    consumer.accept("[Raknetify] C: BUF: %.2fMB; S: BUF: %.2fMB".formatted((double)logger.getCurrentQueuedBytes() / 1024.0 / 1024.0, (double)serverSync.getQueuedBytes() / 1024.0 / 1024.0));
                } else {
                    consumer.accept("[Raknetify] C: BUF: %.2fMB".formatted((double)logger.getCurrentQueuedBytes() / 1024.0 / 1024.0));
                }
                consumer.accept("[Raknetify] C: I: %s, O: %s".formatted(logger.getMeasureTrafficInFormatted(), logger.getMeasureTrafficOutFormatted()));
                consumer.accept("[Raknetify] C: ERR: %.4f%%, %d tx, %d rx, BST: %d".formatted(logger.getMeasureErrorRate() * 100.0, logger.getMeasureTX(), logger.getMeasureRX(), logger.getMeasureBurstTokens() + (long)config.getDefaultPendingFrameSets()));
                if (serverSync != null && serverSync.isRemoteSupported()) {
                    consumer.accept("[Raknetify] S: ERR: %.4f%%, %d tx, %d rx, BST: %d".formatted(serverSync.getErrorRate() * 100.0, serverSync.getTX(), serverSync.getRX(), serverSync.getBurst()));
                }
            } else {
                consumer.accept("[Raknetify] A: true, MTU: %d".formatted(config.getMTU()));
            }
            MultiChannelingStreamingCompression compression = (MultiChannelingStreamingCompression)channel.pipeline().get(MultiChannelingStreamingCompression.class);
            if (compression != null && compression.isActive()) {
                consumer.accept("[Raknetify] CRatio: I: %.2f%%, O: %.2f%%".formatted(compression.getInCompressionRatio() * 100.0, compression.getOutCompressionRatio() * 100.0));
            }
            return;
        }
        consumer.accept("[Raknetify] A: false");
    }
}

