/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.client.pipeline;

import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.packet.ClientHandshake;
import network.ycc.raknet.packet.ConnectionFailed;
import network.ycc.raknet.packet.ConnectionReply1;
import network.ycc.raknet.packet.ConnectionReply2;
import network.ycc.raknet.packet.ConnectionRequest;
import network.ycc.raknet.packet.ConnectionRequest1;
import network.ycc.raknet.packet.ConnectionRequest2;
import network.ycc.raknet.packet.InvalidVersion;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.packet.ServerHandshake;
import network.ycc.raknet.pipeline.AbstractConnectionInitializer;

public class ConnectionInitializer
extends AbstractConnectionInitializer {
    private int cr1Retries = 0;

    public ConnectionInitializer(ChannelPromise connectPromise) {
        super(connectPromise);
    }

    public void channelRead0(ChannelHandlerContext ctx, Packet msg) {
        RakNet.Config config = RakNet.config(ctx);
        if (msg instanceof ConnectionFailed) {
            throw new IllegalStateException("Connection failed");
        }
        switch (this.state) {
            case CR1: {
                if (msg instanceof ConnectionReply1) {
                    ConnectionReply1 cr1 = (ConnectionReply1)msg;
                    cr1.getMagic().verify(config.getMagic());
                    config.setMTU(cr1.getMtu());
                    config.setServerId(cr1.getServerId());
                    this.state = AbstractConnectionInitializer.State.CR2;
                    break;
                }
                if (!(msg instanceof InvalidVersion)) break;
                this.fail((Throwable)((Object)new InvalidVersion.InvalidVersionException()));
                break;
            }
            case CR2: {
                if (msg instanceof ConnectionReply2) {
                    ConnectionReply2 cr2 = (ConnectionReply2)msg;
                    cr2.getMagic().verify(config.getMagic());
                    config.setMTU(cr2.getMtu());
                    config.setServerId(cr2.getServerId());
                    this.state = AbstractConnectionInitializer.State.CR3;
                    ConnectionRequest packet = new ConnectionRequest(config.getClientId());
                    ctx.writeAndFlush((Object)packet).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                    break;
                }
                if (!(msg instanceof ConnectionFailed)) break;
                this.fail((Throwable)new ChannelException("RakNet connection failed"));
                break;
            }
            case CR3: {
                if (!(msg instanceof ServerHandshake)) break;
                ClientHandshake packet = new ClientHandshake(((ServerHandshake)msg).getTimestamp(), (InetSocketAddress)ctx.channel().remoteAddress(), ((ServerHandshake)msg).getnExtraAddresses());
                ctx.writeAndFlush((Object)packet).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                this.startPing(ctx);
                this.finish(ctx);
                return;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
            }
        }
        this.sendRequest(ctx);
    }

    @Override
    public void sendRequest(ChannelHandlerContext ctx) {
        RakNet.Config config = RakNet.config(ctx);
        switch (this.state) {
            case CR1: {
                ConnectionRequest1 packet = new ConnectionRequest1(config.getMagic(), config.getProtocolVersion(), Math.max(config.getMTU() - this.cr1Retries * 16, 130));
                ++this.cr1Retries;
                ctx.writeAndFlush((Object)packet).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                break;
            }
            case CR2: {
                ConnectionRequest2 packet = new ConnectionRequest2(config.getMagic(), config.getMTU(), config.getClientId(), (InetSocketAddress)ctx.channel().remoteAddress());
                ctx.writeAndFlush((Object)packet).addListener((GenericFutureListener)RakNet.INTERNAL_WRITE_LISTENER);
                break;
            }
            case CR3: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
            }
        }
    }

    @Override
    protected void removeHandler(ChannelHandlerContext ctx) {
        ctx.channel().pipeline().remove((ChannelHandler)this);
    }
}

