/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.packet.ConnectionFailed;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.pipeline.PingProducer;

public abstract class AbstractConnectionInitializer
extends SimpleChannelInboundHandler<Packet> {
    public static final String NAME = "rn-init-connect";
    protected final ChannelPromise connectPromise;
    protected State state = State.CR1;
    protected ScheduledFuture<?> sendTimer = null;
    protected ScheduledFuture<?> connectTimer = null;

    public AbstractConnectionInitializer(ChannelPromise connectPromise) {
        this.connectPromise = connectPromise;
    }

    protected abstract void sendRequest(ChannelHandlerContext var1);

    protected abstract void removeHandler(ChannelHandlerContext var1);

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.sendTimer = ctx.channel().eventLoop().scheduleAtFixedRate(() -> this.sendRequest(ctx), 0L, 50L, TimeUnit.MILLISECONDS);
        this.connectTimer = ctx.channel().eventLoop().schedule(this::doTimeout, (long)ctx.channel().config().getConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
        this.sendRequest(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.sendTimer.cancel(false);
        this.connectTimer.cancel(false);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        RakNet.Config config = RakNet.config(ctx);
        ctx.writeAndFlush((Object)new ConnectionFailed(config.getMagic())).addListener(v -> this.fail(cause));
    }

    protected void startPing(ChannelHandlerContext ctx) {
        ctx.channel().pipeline().addAfter(NAME, "rn-ping-producer", (ChannelHandler)new PingProducer());
    }

    protected void finish(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        this.connectPromise.trySuccess();
        this.removeHandler(ctx);
        channel.pipeline().fireChannelActive();
    }

    protected void fail(Throwable cause) {
        this.connectPromise.tryFailure(cause);
    }

    protected void doTimeout() {
        this.fail((Throwable)new ConnectTimeoutException("connection timed out"));
    }

    protected static enum State {
        CR1,
        CR2,
        CR3;

    }
}

