/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.config;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.frame.FrameData;
import network.ycc.raknet.packet.AlreadyConnected;
import network.ycc.raknet.packet.ClientHandshake;
import network.ycc.raknet.packet.ConnectionBanned;
import network.ycc.raknet.packet.ConnectionFailed;
import network.ycc.raknet.packet.ConnectionReply1;
import network.ycc.raknet.packet.ConnectionReply2;
import network.ycc.raknet.packet.ConnectionRequest;
import network.ycc.raknet.packet.ConnectionRequest1;
import network.ycc.raknet.packet.ConnectionRequest2;
import network.ycc.raknet.packet.Disconnect;
import network.ycc.raknet.packet.FrameSet;
import network.ycc.raknet.packet.FramedPacket;
import network.ycc.raknet.packet.InvalidVersion;
import network.ycc.raknet.packet.NoFreeConnections;
import network.ycc.raknet.packet.Packet;
import network.ycc.raknet.packet.Ping;
import network.ycc.raknet.packet.Pong;
import network.ycc.raknet.packet.Reliability;
import network.ycc.raknet.packet.ServerHandshake;
import network.ycc.raknet.packet.SimplePacket;
import network.ycc.raknet.packet.UnconnectedPing;
import network.ycc.raknet.packet.UnconnectedPong;

public class DefaultCodec
implements RakNet.Codec {
    public static final DefaultCodec INSTANCE = new DefaultCodec();
    public static final int PING = 0;
    public static final int UNCONNECTED_PING = 1;
    public static final int PONG = 3;
    public static final int OPEN_CONNECTION_REQUEST_1 = 5;
    public static final int OPEN_CONNECTION_REPLY_1 = 6;
    public static final int OPEN_CONNECTION_REQUEST_2 = 7;
    public static final int OPEN_CONNECTION_REPLY_2 = 8;
    public static final int CONNECTION_REQUEST = 9;
    public static final int SND_RECEIPT_ACKED = 14;
    public static final int SND_RECEIPT_LOSS = 15;
    public static final int SERVER_HANDSHAKE = 16;
    public static final int CONNECTION_FAILED = 17;
    public static final int ALREADY_CONNECTED = 18;
    public static final int CLIENT_HANDSHAKE = 19;
    public static final int NO_FREE_CONNECTIONS = 20;
    public static final int CLIENT_DISCONNECT = 21;
    public static final int CONNECTION_BANNED = 23;
    public static final int INVALID_VERSION = 25;
    public static final int UNCONNECTED_PONG = 28;
    public static final int FRAME_DATA_START = 128;
    public static final int FRAME_DATA_END = 143;
    public static final int NACK = 160;
    public static final int ACK = 192;
    protected final Int2ObjectOpenHashMap<Function<ByteBuf, ? extends Packet>> decoders = new Int2ObjectOpenHashMap();
    protected final Int2ObjectOpenHashMap<BiConsumer<? extends Packet, ByteBuf>> encoders = new Int2ObjectOpenHashMap();
    protected final Object2IntOpenHashMap<Class<?>> idFromClass = new Object2IntOpenHashMap();
    protected final IntOpenHashSet framedPacketIds = new IntOpenHashSet();

    public DefaultCodec() {
        this.register(0, Ping.class, Ping::new);
        this.register(1, UnconnectedPing.class, UnconnectedPing::new);
        this.register(3, Pong.class, Pong::new);
        this.register(5, ConnectionRequest1.class, ConnectionRequest1::new);
        this.register(6, ConnectionReply1.class, ConnectionReply1::new);
        this.register(7, ConnectionRequest2.class, ConnectionRequest2::new);
        this.register(8, ConnectionReply2.class, ConnectionReply2::new);
        this.register(9, ConnectionRequest.class, ConnectionRequest::new);
        this.register(16, ServerHandshake.class, ServerHandshake::new);
        this.register(17, ConnectionFailed.class, ConnectionFailed::new);
        this.register(18, AlreadyConnected.class, AlreadyConnected::new);
        this.register(19, ClientHandshake.class, ClientHandshake::new);
        this.register(20, NoFreeConnections.class, NoFreeConnections::new);
        this.register(21, Disconnect.class, Disconnect::new);
        this.register(23, ConnectionBanned.class, ConnectionBanned::new);
        this.register(25, InvalidVersion.class, InvalidVersion::new);
        this.register(28, UnconnectedPong.class, UnconnectedPong::new);
        for (int i = 128; i <= 143; ++i) {
            this.register(i, FrameSet.class, FrameSet::read, FrameSet::write);
        }
        this.register(160, Reliability.NACK.class, Reliability.NACK::new);
        this.register(192, Reliability.ACK.class, Reliability.ACK::new);
        this.idFromClass.defaultReturnValue(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FrameData encode(FramedPacket packet, ByteBufAllocator alloc) {
        if (packet instanceof FrameData) {
            return ((FrameData)packet).retain();
        }
        ByteBuf out = alloc.ioBuffer(packet.sizeHint());
        try {
            this.encode((Packet)packet, out);
            FrameData frameData = FrameData.read(out, out.readableBytes(), false);
            frameData.setReliability(packet.getReliability());
            frameData.setOrderChannel(packet.getOrderChannel());
            FrameData frameData2 = frameData;
            return frameData2;
        }
        finally {
            out.release();
        }
    }

    @Override
    public void encode(Packet packet, ByteBuf out) {
        if (!this.idFromClass.containsKey(packet.getClass())) {
            throw new IllegalArgumentException("Unknown encoder for " + packet.getClass());
        }
        int packetId = this.packetIdFor(packet.getClass());
        BiConsumer encoder = (BiConsumer)this.encoders.get(packetId);
        encoder.accept(packet, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf produceEncoded(Packet packet, ByteBufAllocator alloc) {
        if (packet instanceof FrameSet && ((FrameSet)packet).getRoughSize() >= 128) {
            return ((FrameSet)packet).produce(alloc);
        }
        ByteBuf buf = alloc.ioBuffer(packet.sizeHint());
        try {
            this.encode(packet, buf);
            ByteBuf byteBuf = buf.retain();
            return byteBuf;
        }
        finally {
            buf.release();
        }
    }

    @Override
    public Packet decode(ByteBuf buf) {
        short packetId = buf.getUnsignedByte(buf.readerIndex());
        Function decoder = (Function)this.decoders.get((int)packetId);
        if (decoder == null) {
            throw new IllegalArgumentException("Unknown decoder for packet ID " + packetId);
        }
        return (Packet)decoder.apply(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FramedPacket decode(FrameData data) {
        int packetId = data.getPacketId();
        Function decoder = (Function)this.decoders.get(packetId);
        if (decoder == null || !this.framedPacketIds.contains(packetId)) {
            return data.retain();
        }
        ByteBuf buf = data.createData();
        try {
            FramedPacket out = (FramedPacket)decoder.apply(buf);
            out.setReliability(data.getReliability());
            out.setOrderChannel(data.getOrderChannel());
            FramedPacket framedPacket = out;
            return framedPacket;
        }
        finally {
            buf.release();
        }
    }

    @Override
    public int packetIdFor(Class<? extends Packet> type) {
        return this.idFromClass.getInt(type);
    }

    protected <T extends SimplePacket> void register(int id, Class<T> clz, Supplier<T> cons) {
        this.register(id, clz, this.decodeSimple(cons), this.encodeSimple(id));
    }

    protected <T extends Packet> void register(int id, Class<? extends Packet> clz, Function<ByteBuf, T> decoder, BiConsumer<T, ByteBuf> encoder) {
        this.idFromClass.put(clz, id);
        this.decoders.put(id, decoder);
        this.encoders.put(id, encoder);
        if (FramedPacket.class.isAssignableFrom(clz)) {
            this.framedPacketIds.add(id);
        }
    }

    protected <T extends SimplePacket> Function<ByteBuf, T> decodeSimple(Supplier<T> cons) {
        return buf -> {
            SimplePacket inst = (SimplePacket)cons.get();
            buf.skipBytes(1);
            inst.decode((ByteBuf)buf);
            return inst;
        };
    }

    protected <T extends SimplePacket> BiConsumer<T, ByteBuf> encodeSimple(int id) {
        return (packet, buf) -> {
            buf.writeByte(id);
            packet.encode((ByteBuf)buf);
        };
    }
}

