/*
 * Decompiled with CFR 0.152.
 */
package network.ycc.raknet.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import network.ycc.raknet.RakNet;
import network.ycc.raknet.frame.Frame;
import network.ycc.raknet.utils.UINT;

public class FrameSplitter
extends MessageToMessageEncoder<Frame> {
    public static final String NAME = "rn-split";
    protected int nextSplitId = 0;
    protected int nextReliableId = 0;

    protected void encode(ChannelHandlerContext ctx, Frame packet, List<Object> list) {
        RakNet.Config config = RakNet.config(ctx);
        int maxSize = config.getMTU() - 56;
        if (packet.getRoughPacketSize() > maxSize) {
            int splits = packet.fragment(this.getNextSplitID(), maxSize, this.nextReliableId, list);
            this.nextReliableId = UINT.B3.plus(this.nextReliableId, splits);
        } else {
            if (packet.getReliability().isReliable) {
                packet.setReliableIndex(this.getNextReliableId());
            }
            list.add((Object)packet.retain());
        }
    }

    protected int getNextSplitID() {
        int splitId = this.nextSplitId;
        this.nextSplitId = UINT.B2.plus(this.nextSplitId, 1);
        return splitId;
    }

    protected int getNextReliableId() {
        int reliableIndex = this.nextReliableId;
        this.nextReliableId = UINT.B3.plus(this.nextReliableId, 1);
        return reliableIndex;
    }
}

