/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.extendedcrafting.tileentity.FluxAlternatorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FluxAlternatorBlock
extends BaseTileEntityBlock {
    private static final VoxelShape SHAPE_DOWN = VoxelShapeBuilder.builder().cuboid(0.0, 10.0, 0.0, 16.0, 16.0, 16.0).cuboid(4.0, 0.0, 4.0, 12.0, 10.0, 12.0).build();
    private static final VoxelShape SHAPE_UP = VoxelShapeBuilder.builder().cuboid(0.0, 0.0, 0.0, 16.0, 6.0, 16.0).cuboid(4.0, 6.0, 4.0, 12.0, 16.0, 12.0).build();
    private static final VoxelShape SHAPE_NORTH = VoxelShapeBuilder.builder().cuboid(0.0, 0.0, 10.0, 16.0, 16.0, 16.0).cuboid(4.0, 4.0, 0.0, 12.0, 12.0, 10.0).build();
    private static final VoxelShape SHAPE_SOUTH = VoxelShapeBuilder.builder().cuboid(0.0, 0.0, 0.0, 16.0, 16.0, 6.0).cuboid(4.0, 4.0, 6.0, 12.0, 12.0, 16.0).build();
    private static final VoxelShape SHAPE_EAST = VoxelShapeBuilder.builder().cuboid(10.0, 0.0, 0.0, 16.0, 16.0, 16.0).cuboid(0.0, 4.0, 4.0, 16.0, 12.0, 12.0).build();
    private static final VoxelShape SHAPE_WEST = VoxelShapeBuilder.builder().cuboid(0.0, 0.0, 0.0, 6.0, 16.0, 16.0).cuboid(6.0, 4.0, 4.0, 16.0, 12.0, 12.0).build();
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public FluxAlternatorBlock() {
        super(SoundType.METAL, 5.0f, 10.0f, true);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FluxAlternatorTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof FluxAlternatorTileEntity) {
            FluxAlternatorTileEntity alternator = (FluxAlternatorTileEntity)tile;
            player.openMenu((MenuProvider)alternator, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_EAST;
            case Direction.EAST -> SHAPE_WEST;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

