/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.render.GhostItemRenderer;
import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.client.screen.button.RecipeSelectButton;
import com.blakebr0.extendedcrafting.container.AutoEnderCrafterContainer;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AutoEnderCrafterTileEntity;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class AutoEnderCrafterScreen
extends BaseContainerScreen<AutoEnderCrafterContainer> {
    private static final ResourceLocation BACKGROUND = ExtendedCrafting.resource("textures/gui/auto_ender_crafter.png");
    private AutoEnderCrafterTileEntity tile;

    public AutoEnderCrafterScreen(AutoEnderCrafterContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 176, 194);
    }

    protected void init() {
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        BlockPos pos = ((AutoEnderCrafterContainer)this.getMenu()).getBlockPos();
        this.tile = this.getTileEntity();
        if (this.tile != null) {
            this.addRenderableWidget((GuiEventListener)new RecipeSelectButton(x + 132, y + 7, pos, 0, 33, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.addRenderableWidget((GuiEventListener)new RecipeSelectButton(x + 145, y + 7, pos, 1, 33, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.addRenderableWidget((GuiEventListener)new RecipeSelectButton(x + 158, y + 7, pos, 2, 33, this.tile.getRecipeStorage(), this::onSelectButtonTooltip));
            this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)this.tile.getEnergy()));
        }
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        gfx.drawString(this.font, title, 32, 6, 0x404040, false);
        gfx.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, 0x404040, false);
    }

    protected void renderBg(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        BaseItemStackHandler recipe;
        super.renderBg(gfx, partialTicks, mouseX, mouseY);
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.getProgress() > 0) {
            int i2 = this.getProgressBarScaled();
            gfx.blit(BACKGROUND, x + 92, y + 48, 194, 0, i2 + 1, 16);
        }
        if ((recipe = this.getSelectedRecipe()) != null) {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    ItemStack item = recipe.getStackInSlot(index);
                    GhostItemRenderer.renderItemIntoGui((ItemStack)item, (int)(x + 33 + j * 18), (int)(y + 30 + i * 18), (ItemRenderer)itemRenderer);
                }
            }
            ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
            GhostItemRenderer.renderItemIntoGui((ItemStack)output, (int)(x + 127), (int)(y + 48), (ItemRenderer)itemRenderer);
        }
    }

    private void onSelectButtonTooltip(Button button, GuiGraphics gfx, int mouseX, int mouseY) {
        int index = ((RecipeSelectButton)button).getIndex();
        boolean isSelected = ((RecipeSelectButton)button).isSelected();
        BaseItemStackHandler recipe = this.getRecipeInfo(index);
        if (recipe != null) {
            ArrayList tooltip;
            boolean hasRecipe;
            boolean bl = hasRecipe = !recipe.getStacks().stream().allMatch(ItemStack::isEmpty);
            if (hasRecipe) {
                ItemStack output = recipe.getStackInSlot(recipe.getSlots() - 1);
                tooltip = Lists.newArrayList((Object[])new Component[]{Component.literal((String)(output.getCount() + "x " + output.getHoverName().getString())), Component.literal((String)""), ModTooltips.AUTO_TABLE_DELETE_RECIPE.color(ChatFormatting.WHITE).build()});
                if (isSelected) {
                    tooltip.add(1, ModTooltips.SELECTED.color(ChatFormatting.GREEN).build());
                }
            } else {
                tooltip = Lists.newArrayList((Object[])new Component[]{ModTooltips.AUTO_TABLE_SAVE_RECIPE.color(ChatFormatting.WHITE).build()});
                if (isSelected) {
                    tooltip.add(0, ModTooltips.SELECTED.color(ChatFormatting.GREEN).build());
                    tooltip.add(1, Component.literal((String)""));
                }
            }
            gfx.renderComponentTooltip(this.font, (List)tooltip, mouseX, mouseY);
        }
    }

    private AutoEnderCrafterTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity(((AutoEnderCrafterContainer)this.getMenu()).getBlockPos())) instanceof AutoEnderCrafterTileEntity) {
            AutoEnderCrafterTileEntity crafter = (AutoEnderCrafterTileEntity)tile;
            return crafter;
        }
        return null;
    }

    private BaseItemStackHandler getRecipeInfo(int selected) {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getRecipe(selected);
    }

    private BaseItemStackHandler getSelectedRecipe() {
        if (this.tile == null) {
            return null;
        }
        return this.tile.getRecipeStorage().getSelectedRecipe();
    }

    private int getProgress() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgress();
    }

    private int getProgressRequired() {
        if (this.tile == null) {
            return 0;
        }
        return this.tile.getProgressRequired();
    }

    private int getProgressBarScaled() {
        int i = this.getProgress();
        int j = Math.max(this.getProgressRequired(), i);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }
}

