/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.container;

import com.blakebr0.cucumber.container.BaseContainerMenu;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.slot.BaseItemStackHandlerSlot;
import com.blakebr0.cucumber.inventory.slot.OutputSlot;
import com.blakebr0.extendedcrafting.container.slot.CatalystSlot;
import com.blakebr0.extendedcrafting.init.ModMenuTypes;
import com.blakebr0.extendedcrafting.tileentity.CompressorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class CompressorContainer
extends BaseContainerMenu {
    private CompressorContainer(MenuType<?> type, int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(type, id, playerInventory, CompressorTileEntity.createInventoryHandler(), buffer.readBlockPos());
    }

    private CompressorContainer(MenuType<?> type, int id, Inventory playerInventory, BaseItemStackHandler inventory, BlockPos pos) {
        super(type, id, pos);
        int i;
        this.addSlot((Slot)new OutputSlot((IItemHandler)inventory, 0, 135, 48));
        this.addSlot((Slot)new BaseItemStackHandlerSlot(inventory, 1, 65, 48));
        this.addSlot((Slot)new CatalystSlot(inventory, 2, 38, 48));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 112 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 170));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotNumber < 3) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else {
                ItemStack inputStack = ((Slot)this.slots.get(1)).getItem();
                if (inputStack.isEmpty() || inputStack.is(itemstack1.getItem()) && inputStack.getCount() < inputStack.getMaxStackSize() ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (slotNumber < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : slotNumber < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false))) {
                    return ItemStack.EMPTY;
                }
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public static CompressorContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new CompressorContainer((MenuType)ModMenuTypes.COMPRESSOR.get(), windowId, playerInventory, buffer);
    }

    public static CompressorContainer create(int windowId, Inventory playerInventory, BaseItemStackHandler inventory, BlockPos pos) {
        return new CompressorContainer((MenuType)ModMenuTypes.COMPRESSOR.get(), windowId, playerInventory, inventory, pos);
    }
}

