/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.container;

import com.blakebr0.cucumber.container.BaseContainerMenu;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.container.inventory.ExtendedCraftingInventory;
import com.blakebr0.extendedcrafting.container.slot.AutoTableOutputSlot;
import com.blakebr0.extendedcrafting.container.slot.TableOutputSlot;
import com.blakebr0.extendedcrafting.init.ModMenuTypes;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

public class UltimateAutoTableContainer
extends BaseContainerMenu {
    private final Level level;
    private final Container result;
    private final ExtendedCraftingInventory matrix;

    private UltimateAutoTableContainer(MenuType<?> type, int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(type, id, playerInventory, AutoTableTileEntity.Ultimate.createInventoryHandler(), buffer.readBlockPos());
    }

    private UltimateAutoTableContainer(MenuType<?> type, int id, Inventory playerInventory, BaseItemStackHandler inventory, BlockPos pos) {
        super(type, id, pos);
        int j;
        int i;
        this.level = playerInventory.player.level();
        this.result = new ResultContainer();
        this.matrix = new ExtendedCraftingInventory((AbstractContainerMenu)this, inventory, 9, true);
        this.addSlot(new TableOutputSlot((AbstractContainerMenu)this, this.matrix, this.result, 0, 225, 89));
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.matrix, j + i * 9, 27 + j * 18, 18 + i * 18));
            }
        }
        this.addSlot((Slot)new AutoTableOutputSlot((AbstractContainerMenu)this, (CraftingContainer)this.matrix, (IItemHandler)inventory, 81, 225, 133));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 47 + j * 18, 196 + i * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 47 + j * 18, 254));
        }
        this.slotsChanged((Container)this.matrix);
    }

    public void slotsChanged(Container matrix) {
        if (this.level.isClientSide) {
            return;
        }
        TableCraftingInput inventory = this.matrix.asCraftInput();
        Optional recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)inventory, this.level);
        if (recipe.isPresent()) {
            ItemStack result = ((ITableRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)inventory, (HolderLookup.Provider)this.level.registryAccess());
            this.result.setItem(0, result);
        } else {
            this.result.setItem(0, ItemStack.EMPTY);
        }
        super.slotsChanged(matrix);
    }

    public ItemStack quickMoveStack(Player player, int slotNumber) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotNumber);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (slotNumber == 0 || slotNumber == 82) {
                if (!this.moveItemStackTo(itemstack1, 83, 119, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotNumber >= 83 && slotNumber < 119 ? !this.moveItemStackTo(itemstack1, 1, 82, false) : !this.moveItemStackTo(itemstack1, 83, 119, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public static UltimateAutoTableContainer create(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new UltimateAutoTableContainer((MenuType)ModMenuTypes.ULTIMATE_AUTO_TABLE.get(), windowId, playerInventory, buffer);
    }

    public static UltimateAutoTableContainer create(int windowId, Inventory playerInventory, BaseItemStackHandler inventory, BlockPos pos) {
        return new UltimateAutoTableContainer((MenuType)ModMenuTypes.ULTIMATE_AUTO_TABLE.get(), windowId, playerInventory, inventory, pos);
    }
}

