/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.util.IngredientListCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class CombinationRecipe
implements ICombinationRecipe {
    private final ItemStack result;
    private final Ingredient input;
    private final NonNullList<Ingredient> inputs;
    private final int powerCost;
    private final int powerRate;
    private BiFunction<Integer, ItemStack, ItemStack> transformer;

    public CombinationRecipe(Ingredient input, NonNullList<Ingredient> inputs, ItemStack result, int powerCost, int powerRate) {
        this.input = input;
        this.inputs = inputs;
        this.result = result;
        this.powerCost = powerCost;
        this.powerRate = powerRate;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        if (this.inputs.size() != inventory.ingredientCount() - 1) {
            return false;
        }
        ItemStack input = inventory.getItem(0);
        if (!this.input.test(input)) {
            return false;
        }
        NonNullList inputs = NonNullList.create();
        for (int i = 1; i < inventory.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty()) continue;
            inputs.add((Object)item);
        }
        return RecipeMatcher.findMatches((List)inputs, this.inputs) != null;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider lookup) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.COMBINATION.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.COMBINATION.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList remaining = NonNullList.withSize((int)inventory.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (!item.hasCraftingRemainingItem()) continue;
            remaining.set(i, (Object)item.getCraftingRemainingItem());
        }
        if (this.transformer != null) {
            boolean[] used = new boolean[remaining.size()];
            NonNullList inputs = NonNullList.create();
            inputs.add((Object)this.input);
            inputs.addAll(this.inputs);
            block1: for (int i = 0; i < remaining.size(); ++i) {
                ItemStack stack = inventory.getItem(i);
                for (int j = 0; j < inputs.size(); ++j) {
                    Ingredient input = (Ingredient)inputs.get(j);
                    if (used[j] || !input.test(stack)) continue;
                    ItemStack ingredient = this.transformer.apply(j, stack);
                    used[j] = true;
                    remaining.set(i, (Object)ingredient);
                    continue block1;
                }
            }
        }
        return remaining;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public int getPowerCost() {
        return this.powerCost;
    }

    @Override
    public int getPowerRate() {
        return this.powerRate;
    }

    @Override
    public List<Component> getInputsList() {
        return IngredientListCache.getInstance().getIngredientsList(this, () -> {
            NonNullList ingredients = NonNullList.create();
            ingredients.add((Object)this.input);
            ingredients.addAll(this.inputs);
            return ingredients;
        });
    }

    public void setTransformer(BiFunction<Integer, ItemStack, ItemStack> transformer) {
        this.transformer = transformer;
    }

    public static class Serializer
    implements RecipeSerializer<CombinationRecipe> {
        public static final MapCodec<CombinationRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(recipe -> recipe.input), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(field -> {
            int max = 48;
            Object[] ingredients = (Ingredient[])field.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for Combination recipe");
            }
            return ingredients.length > max ? DataResult.error(() -> "Too many ingredients for Combination recipe. The maximum is: %s".formatted(max)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(recipe -> recipe.inputs), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("power_cost").forGetter(recipe -> recipe.powerCost), (App)Codec.INT.optionalFieldOf("power_rate", (Object)((Integer)ModConfigs.CRAFTING_CORE_POWER_RATE.get())).forGetter(recipe -> recipe.powerRate)).apply((Applicative)builder, CombinationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CombinationRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CombinationRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CombinationRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CombinationRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer)));
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            int powerCost = buffer.readVarInt();
            int powerRate = buffer.readVarInt();
            return new CombinationRecipe(input, (NonNullList<Ingredient>)inputs, result, powerCost, powerRate);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, CombinationRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeVarInt(recipe.inputs.size());
            for (Ingredient ingredient : recipe.inputs) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeVarInt(recipe.powerCost);
            buffer.writeVarInt(recipe.powerRate);
        }
    }
}

