/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ingredient.IngredientWithCount;
import com.blakebr0.extendedcrafting.api.crafting.ICompressorRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class CompressorRecipe
implements ICompressorRecipe {
    private final NonNullList<IngredientWithCount> inputs;
    private final ItemStack result;
    private final Ingredient catalyst;
    private final int powerCost;
    private final int powerRate;

    public CompressorRecipe(NonNullList<IngredientWithCount> input, ItemStack result, Ingredient catalyst, int powerCost, int powerRate) {
        this.inputs = input;
        this.result = result;
        this.catalyst = catalyst;
        this.powerCost = powerCost;
        this.powerRate = powerRate;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        if (inventory.ingredientCount() != 2) {
            return false;
        }
        ItemStack input = inventory.getItem(0);
        ItemStack catalyst = inventory.getItem(1);
        return ((IngredientWithCount)this.inputs.getFirst()).getItems().anyMatch(s -> s.is(input.getItem())) && this.catalyst.test(catalyst);
    }

    public ItemStack assemble(CraftingInput recipeInput, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs.stream().map(ICustomIngredient::toVanilla).collect(Collectors.toCollection(NonNullList::create));
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.COMPRESSOR.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.COMPRESSOR.get();
    }

    public boolean isSpecial() {
        return true;
    }

    @Override
    public int getCount(int index) {
        if (index < 0 || index >= this.inputs.size()) {
            return -1;
        }
        return ((IngredientWithCount)this.inputs.get(index)).getCount();
    }

    @Override
    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    @Override
    public int getPowerCost() {
        return this.powerCost;
    }

    @Override
    public int getPowerRate() {
        return this.powerRate;
    }

    public static class Serializer
    implements RecipeSerializer<CompressorRecipe> {
        public static final MapCodec<CompressorRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IngredientWithCount.CODEC.flatComapMap(ingredient -> NonNullList.of((Object)IngredientWithCount.EMPTY, (Object[])new IngredientWithCount[]{ingredient}), ingredients -> DataResult.success((Object)((IngredientWithCount)ingredients.getFirst()))).fieldOf("ingredient").forGetter(recipe -> recipe.inputs), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.fieldOf("catalyst").forGetter(recipe -> recipe.catalyst), (App)Codec.INT.fieldOf("power_cost").forGetter(recipe -> recipe.powerCost), (App)Codec.INT.optionalFieldOf("power_rate", (Object)((Integer)ModConfigs.COMPRESSOR_POWER_RATE.get())).forGetter(recipe -> recipe.powerRate)).apply((Applicative)builder, CompressorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CompressorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<CompressorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CompressorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static CompressorRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            IngredientWithCount input = (IngredientWithCount)IngredientWithCount.STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Ingredient catalyst = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int powerCost = buffer.readInt();
            int powerRate = buffer.readInt();
            return new CompressorRecipe((NonNullList<IngredientWithCount>)NonNullList.of((Object)IngredientWithCount.EMPTY, (Object[])new IngredientWithCount[]{input}), result, catalyst, powerCost, powerRate);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, CompressorRecipe recipe) {
            IngredientWithCount.STREAM_CODEC.encode((Object)buffer, (Object)((IngredientWithCount)recipe.inputs.getFirst()));
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.catalyst);
            buffer.writeInt(recipe.powerCost);
            buffer.writeInt(recipe.powerRate);
        }
    }
}

