/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.crafting.recipe.ShapelessTableRecipe;
import com.blakebr0.extendedcrafting.init.ModItems;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.blakebr0.extendedcrafting.singularity.SingularityRegistry;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class UltimateSingularityRecipe
extends ShapelessTableRecipe {
    private static final Object2BooleanOpenHashMap<UltimateSingularityRecipe> INGREDIENTS_LOADED = new Object2BooleanOpenHashMap();

    public UltimateSingularityRecipe(ItemStack output) {
        super((NonNullList<Ingredient>)NonNullList.create(), output, 4);
    }

    @Override
    public boolean matches(TableCraftingInput inventory, Level level) {
        NonNullList<Ingredient> ingredients = this.getIngredients();
        return !ingredients.isEmpty() && super.matches(inventory, level);
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        if (!INGREDIENTS_LOADED.getOrDefault((Object)this, false)) {
            super.getIngredients().clear();
            SingularityRegistry.getInstance().getSingularities().stream().filter(singularity -> singularity.isInUltimateSingularity() && singularity.getIngredient() != Ingredient.EMPTY).limit(81L).map(SingularityUtils::getItemForSingularity).map(stack -> DataComponentIngredient.of((boolean)false, (DataComponentMap)stack.getComponentsPatch().split().added(), (ItemLike[])new ItemLike[]{stack.getItem()})).forEach(arg_0 -> super.getIngredients().add(arg_0));
            INGREDIENTS_LOADED.put((Object)this, true);
        }
        return super.getIngredients();
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.ULTIMATE_SINGULARITY.get();
    }

    public static void invalidate() {
        INGREDIENTS_LOADED.clear();
    }

    public static class Serializer
    implements RecipeSerializer<UltimateSingularityRecipe> {
        public static final MapCodec<UltimateSingularityRecipe> CODEC = MapCodec.unit(() -> new UltimateSingularityRecipe(new ItemStack((ItemLike)ModItems.ULTIMATE_SINGULARITY.get())));
        public static final StreamCodec<RegistryFriendlyByteBuf, UltimateSingularityRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<UltimateSingularityRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UltimateSingularityRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static UltimateSingularityRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new UltimateSingularityRecipe(new ItemStack((ItemLike)ModItems.ULTIMATE_SINGULARITY.get()));
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, UltimateSingularityRecipe recipe) {
        }
    }
}

