/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.item;

import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;

public class SingularityItem
extends BaseItem
implements IColored {
    public SingularityItem() {
        super(p -> p.rarity(Rarity.UNCOMMON));
    }

    public Component getName(ItemStack stack) {
        Singularity singularity = SingularityUtils.getSingularity(stack);
        if (singularity == null) {
            return Localizable.of((String)this.getDescriptionId(stack)).args(new Object[]{"NULL"}).build();
        }
        return Localizable.of((String)this.getDescriptionId(stack)).args(new Object[]{singularity.getDisplayName()}).build();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        Singularity singularity = SingularityUtils.getSingularity(stack);
        if (singularity != null) {
            String modid = singularity.getId().getNamespace();
            if (!modid.equals("extendedcrafting")) {
                tooltip.add(ModTooltips.getAddedByTooltip(modid));
            }
            if (flag.isAdvanced()) {
                tooltip.add((Component)ModTooltips.SINGULARITY_ID.args(new Object[]{singularity.getId().toString()}).color(ChatFormatting.DARK_GRAY).build());
            }
        }
    }

    public int getColor(int i, ItemStack stack) {
        Singularity singularity = SingularityUtils.getSingularity(stack);
        if (singularity == null) {
            return -1;
        }
        return i == 0 ? singularity.getUnderlayColor() : (i == 1 ? singularity.getOverlayColor() : -1);
    }
}

