/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.network.payload;

import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.tileentity.AutoTableTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RunningSwitchPayload(BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RunningSwitchPayload> TYPE = new CustomPacketPayload.Type(ExtendedCrafting.resource("running_switch"));
    public static final StreamCodec<FriendlyByteBuf, RunningSwitchPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RunningSwitchPayload::pos, RunningSwitchPayload::new);

    public CustomPacketPayload.Type<RunningSwitchPayload> type() {
        return TYPE;
    }

    public static void handleServer(RunningSwitchPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(payload.pos);
            if (tile instanceof AutoTableTileEntity) {
                AutoTableTileEntity table = (AutoTableTileEntity)tile;
                table.toggleRunning();
            }
        });
    }
}

