/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.extendedcrafting.api.crafting.IFluxCrafterRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AutoFluxCrafterContainer;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.tileentity.FluxCrafterTileEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class AutoFluxCrafterTileEntity
extends FluxCrafterTileEntity
implements MenuProvider {
    private final BaseEnergyStorage energy = new BaseEnergyStorage(((Integer)ModConfigs.AUTO_FLUX_CRAFTER_POWER_CAPACITY.get()).intValue(), () -> ((AutoFluxCrafterTileEntity)this).setChangedFast());
    private final TableRecipeStorage recipeStorage = new TableRecipeStorage(10);

    public AutoFluxCrafterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.AUTO_FLUX_CRAFTER.get(), pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.put("Energy", this.energy.serializeNBT(lookup));
        tag.merge(this.recipeStorage.serializeNBT(lookup));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.recipeStorage.deserializeNBT(lookup, tag);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            this.getRecipeStorage().validate(inventory -> this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.FLUX_CRAFTER.get(), (RecipeInput)inventory, this.level).map(r -> ((IFluxCrafterRecipe)r.value()).assemble((RecipeInput)inventory, (HolderLookup.Provider)this.level.registryAccess())).orElse(ItemStack.EMPTY));
        }
    }

    @Override
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return AutoFluxCrafterContainer.create(windowId, playerInventory, this.getInventory(), this.getBlockPos());
    }

    @Override
    public TableRecipeStorage getRecipeStorage() {
        return this.recipeStorage;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutoFluxCrafterTileEntity tile) {
        int selected;
        FluxCrafterTileEntity.tick(level, pos, state, tile);
        int insertPowerRate = (Integer)ModConfigs.AUTO_FLUX_CRAFTER_INSERT_POWER_RATE.get();
        if (tile.getEnergy().getEnergyStored() >= insertPowerRate && (selected = tile.getRecipeStorage().getSelected()) != -1) {
            tile.getAboveInventory().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    boolean inserted;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.isEmpty() || handler.extractItem(i, 1, true).isEmpty() || !(inserted = tile.tryInsertItemIntoGrid(stack))) continue;
                    handler.extractItem(i, 1, false);
                    break;
                }
            });
        }
    }

    public void selectRecipe(int index) {
        this.getRecipeStorage().setSelected(index);
        this.setChangedAndDispatch();
    }

    public void saveRecipe(int index) {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        CraftingInput inventory = this.getInventory().toCraftingInput(3, 3, 0, 9);
        RecipeHolder recipe = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.FLUX_CRAFTER.get(), (RecipeInput)inventory, level).orElse(null);
        ItemStack result = ItemStack.EMPTY;
        if (recipe != null) {
            result = ((IFluxCrafterRecipe)recipe.value()).assemble((RecipeInput)inventory, (HolderLookup.Provider)level.registryAccess());
        }
        this.getRecipeStorage().setRecipe(index, this.getInventory(), result);
        this.setChangedAndDispatch();
    }

    public void deleteRecipe(int index) {
        this.getRecipeStorage().unsetRecipe(index);
        this.setChangedAndDispatch();
    }

    public BaseEnergyStorage getEnergy() {
        return this.energy;
    }

    private void addStackToSlot(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackInSlot = inventory.getStackInSlot(slot);
        if (stackInSlot.isEmpty()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)stackInSlot, (int)stack.getCount()));
        }
    }

    private Optional<IItemHandler> getAboveInventory() {
        Level level = this.getLevel();
        BlockPos pos = this.getBlockPos().above();
        if (level != null) {
            IItemHandler capability = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.DOWN);
            return Optional.ofNullable(capability);
        }
        return Optional.empty();
    }

    private boolean tryInsertItemIntoGrid(ItemStack input) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackToPut = ItemStack.EMPTY;
        BaseItemStackHandler recipe = this.getRecipeStorage().getSelectedRecipe();
        int slotToPut = -1;
        boolean isGridChanged = false;
        int slots = inventory.getSlots() - 1;
        for (int i = 0; i < slots; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            ItemStack recipeStack = recipe.getStackInSlot(i);
            if (!slot.isEmpty() && !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)slot) || !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)recipeStack) || !slot.isEmpty() && slot.getCount() >= slot.getMaxStackSize()) continue;
            if (slot.isEmpty()) {
                slotToPut = i;
                isGridChanged = true;
                break;
            }
            if (!stackToPut.isEmpty() && slot.getCount() >= stackToPut.getCount()) continue;
            slotToPut = i;
            stackToPut = slot;
        }
        this.isGridChanged = isGridChanged;
        if (slotToPut > -1) {
            int insertPowerRate = (Integer)ModConfigs.AUTO_FLUX_CRAFTER_INSERT_POWER_RATE.get();
            ItemStack toInsert = StackHelper.withSize((ItemStack)input, (int)1, (boolean)false);
            this.addStackToSlot(toInsert, slotToPut);
            this.getEnergy().extractEnergy(insertPowerRate, false);
            return true;
        }
        return false;
    }
}

