/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.jea.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.melanx.jea.AdvancementInfo;
import de.melanx.jea.JustEnoughAdvancements;
import de.melanx.jea.JustEnoughAdvancementsJEIPlugin;
import de.melanx.jea.api.client.IAdvancementInfo;
import de.melanx.jea.api.client.Jea;
import de.melanx.jea.recipe.AdvancementRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;

public class ClientAdvancements {
    private static ImmutableMap<ResourceLocation, AdvancementInfo> advancements = ImmutableMap.of();

    public static void update(Set<AdvancementInfo> info) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            advancements = (ImmutableMap)info.stream().collect(ImmutableMap.toImmutableMap(x -> x.id, Function.identity()));
            JustEnoughAdvancementsJEIPlugin.runtimeOptional(runtime -> ClientAdvancements.updateAdvancementIngredientsJEI(runtime, 3));
        }
    }

    private static void updateAdvancementIngredientsJEI(IJeiRuntime runtime, int tries) {
        try {
            IIngredientManager imgr = runtime.getIngredientManager();
            ImmutableList ingredients = ImmutableList.copyOf((Collection)imgr.getAllIngredients(Jea.ADVANCEMENT_TYPE));
            if (!ingredients.isEmpty()) {
                imgr.removeIngredientsAtRuntime(Jea.ADVANCEMENT_TYPE, (Collection)ingredients);
            }
            if (!advancements.isEmpty()) {
                imgr.addIngredientsAtRuntime(Jea.ADVANCEMENT_TYPE, ClientAdvancements.getIAdvancements());
            }
        }
        catch (ConcurrentModificationException e) {
            if (tries > 0) {
                JustEnoughAdvancements.LOGGER.warn("Failed to update advancement ingredients for JEI. Trying again.");
                ClientAdvancements.updateAdvancementIngredientsJEI(runtime, tries - 1);
            }
            JustEnoughAdvancements.LOGGER.error("Failed to update advancement ingredients for JEI. Ignoring this for now. Advancements might be out of sync.");
        }
    }

    public static Set<ResourceLocation> getAdvancementIds() {
        return advancements.keySet();
    }

    public static Collection<AdvancementInfo> getAdvancements() {
        return advancements.values();
    }

    public static Collection<IAdvancementInfo> getIAdvancements() {
        return advancements.values();
    }

    public static AdvancementInfo getInfo(ResourceLocation key) {
        return (AdvancementInfo)advancements.get((Object)key);
    }

    public static List<AdvancementRecipe> collectRecipes() {
        ArrayList<AdvancementRecipe> recipes = new ArrayList<AdvancementRecipe>();
        for (AdvancementInfo info : ClientAdvancements.getAdvancements()) {
            if (info.getDisplay() == null) continue;
            recipes.add(new AdvancementRecipe(info));
        }
        JustEnoughAdvancements.LOGGER.info("Collected {} advancement criterion recipes.", (Object)recipes.size());
        return ImmutableList.copyOf(recipes);
    }
}

