/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.jea.recipe;

import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.jea.AdvancementInfo;
import de.melanx.jea.api.client.Jea;
import de.melanx.jea.client.ClientAdvancementProgress;
import de.melanx.jea.client.ClientAdvancements;
import de.melanx.jea.recipe.AdvancementCompletion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.moddingx.libx.render.RenderHelper;

public class AdvancementRecipe {
    private final AdvancementInfo info;
    private final AdvancementInfo parent;

    public AdvancementRecipe(AdvancementInfo info) {
        this.info = info;
        this.parent = this.info.getParent().isPresent() ? ClientAdvancements.getInfo(this.info.getParent().get()) : null;
    }

    public ResourceLocation id() {
        return this.info.id;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IFocusGroup focus) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 62, 0).addIngredient(Jea.ADVANCEMENT_TYPE, (Object)this.info)).setCustomRenderer(Jea.ADVANCEMENT_TYPE, Jea.ADVANCEMENT_RECIPE_RENDERER);
        if (this.parent != null) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).addIngredient(Jea.ADVANCEMENT_TYPE, (Object)this.parent)).setCustomRenderer(Jea.ADVANCEMENT_TYPE, Jea.ADVANCEMENT_RECIPE_RENDERER_TINY);
        }
    }

    public void draw(IRecipeSlotsView slots, GuiGraphics graphics, double mouseX, double mouseY, IDrawableStatic complete, IDrawableStatic incomplete) {
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        int width = font.width((FormattedText)this.info.getFormattedDisplayName());
        graphics.drawString(font, this.info.getFormattedDisplayName(), 75 - width / 2, 29, 0xFFFFFF, false);
        AdvancementCompletion advancementCompletion = this.getCriterionCompletion();
        graphics.pose().pushPose();
        graphics.pose().translate(129.0f, 5.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (mouseX >= 129.0 && mouseX <= 145.0 && mouseY >= 5.0 && mouseY <= 21.0) {
            RenderSystem.disableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            graphics.blit(RenderHelper.TEXTURE_WHITE, 0, 0, 0.0f, 0.0f, 16, 16, 256, 256);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        graphics.pose().translate(0.0f, 0.0f, 10.0f);
        graphics.pose().scale(0.9411765f, 0.9411765f, 0.0f);
        graphics.pose().translate(1.0f, 1.0f, 0.0f);
        advancementCompletion.draw(graphics, complete, incomplete);
        RenderSystem.disableBlend();
        graphics.pose().popPose();
        if (this.info.getDisplay() != null) {
            Component description = this.info.getDisplay().getDescription();
            List lines = ComponentRenderUtils.wrapComponents((FormattedText)description, (int)130, (Font)font);
            for (int i = 0; i < lines.size(); ++i) {
                FormattedCharSequence formattedCharSequence = (FormattedCharSequence)lines.get(i);
                Objects.requireNonNull(font);
                graphics.drawString(font, formattedCharSequence, 10, 50 + (9 + 2) * i, 0xFFFFFF, true);
            }
        }
        mc.renderBuffers().bufferSource().endBatch();
    }

    public List<Component> getTooltip(IRecipeSlotsView slots, double mouseX, double mouseY) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (mouseX >= 129.0 && mouseX <= 145.0 && mouseY >= 5.0 && mouseY <= 21.0) {
            this.getCriterionCompletion().addTooltip(tooltip, this.info);
        }
        return tooltip;
    }

    private AdvancementCompletion getCriterionCompletion() {
        AdvancementProgress progress = ClientAdvancementProgress.getProgress(this.info.getId());
        if (progress != null) {
            if (progress.isDone()) {
                return AdvancementCompletion.COMPLETE;
            }
            if (progress.hasProgress()) {
                return AdvancementCompletion.PARTIALLY_COMPLETE;
            }
            return AdvancementCompletion.INCOMPLETE;
        }
        return AdvancementCompletion.INCOMPLETE;
    }
}

