/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.PlayerSelectorArgumentResolver;
import java.util.List;
import me.usainsrht.ujobs.UJobsPlugin;
import me.usainsrht.ujobs.models.Job;
import me.usainsrht.ujobs.models.PlayerJobData;
import me.usainsrht.ujobs.utils.JobExpUtils;
import me.usainsrht.ujobs.utils.MessageUtil;
import me.usainsrht.ujobs.yaml.YamlCommand;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MainCommand {
    public static LiteralCommandNode<CommandSourceStack> create(UJobsPlugin plugin, YamlCommand yamlCommand) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)yamlCommand.getName()).requires(context -> {
            if (yamlCommand.getPermission() != null) {
                return context.getSender().hasPermission(yamlCommand.getPermission());
            }
            return true;
        })).executes(context -> {
            CommandSender patt0$temp = ((CommandSourceStack)context.getSource()).getSender();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                plugin.getGuiManager().openJobGUI(player);
            }
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(context -> context.getSender().hasPermission("ujobs.admin.reload"))).executes(context -> {
            plugin.getConfigManager().reload();
            plugin.getJobManager().loadJobs();
            MessageUtil.send((Audience)((CommandSourceStack)context.getSource()).getSender(), plugin.getConfigManager().getMessage("reload"));
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"addexp").requires(context -> context.getSender().hasPermission("ujobs.admin.addexp"))).executes(context -> {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Usage: /ujobs addexp <player> <job> <amount>");
            return -1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.player()).executes(context -> {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Usage: /ujobs addexp <player> <job> <amount>");
            return -1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"job", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            plugin.getJobManager().getJobs().keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(context -> {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Usage: /ujobs addexp <player> <job> <amount>");
            return -1;
        })).then(Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(context -> {
            PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class);
            Player target = (Player)((List)targetResolver.resolve((CommandSourceStack)context.getSource())).getFirst();
            String jobId = StringArgumentType.getString((CommandContext)context, (String)"job");
            double amount = DoubleArgumentType.getDouble((CommandContext)context, (String)"amount");
            if (plugin.getJobManager().getJobs().containsKey(jobId)) {
                Job job = plugin.getJobManager().getJobs().get(jobId);
                Job.ActionReward reward = new Job.ActionReward(amount, 0.0);
                JobExpUtils.processJobExp(target, job, reward, 1);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Job not found: " + jobId);
            return -1;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setlevel").requires(context -> context.getSender().hasPermission("ujobs.admin.setlevel"))).executes(context -> {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Usage: /ujobs setlevel <player> <job> <level>");
            return -1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)ArgumentTypes.player()).executes(context -> {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Usage: /ujobs setlevel <player> <job> <level>");
            return -1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"job", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            plugin.getJobManager().getJobs().keySet().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(context -> {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Usage: /ujobs setlevel <player> <job> <level>");
            return -1;
        })).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            PlayerSelectorArgumentResolver targetResolver = (PlayerSelectorArgumentResolver)context.getArgument("target", PlayerSelectorArgumentResolver.class);
            Player target = (Player)((List)targetResolver.resolve((CommandSourceStack)context.getSource())).getFirst();
            String jobId = StringArgumentType.getString((CommandContext)context, (String)"job");
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            if (plugin.getJobManager().getJobs().containsKey(jobId)) {
                PlayerJobData playerJobData = plugin.getStorage().getCached(target.getUniqueId());
                PlayerJobData.JobStats jobStats = playerJobData.getJobStats(jobId);
                jobStats.setLevel(level);
                jobStats.setExp(0.0);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).getSender().sendMessage("Job not found: " + jobId);
            return -1;
        })))))).build();
    }
}

