/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.listeners.job_actions;

import me.usainsrht.ujobs.managers.JobManager;
import me.usainsrht.ujobs.models.BuiltInActions;
import me.usainsrht.ujobs.models.Job;
import org.bukkit.block.Block;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class BreakListener
implements Listener {
    JobManager jobManager;

    public BreakListener(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreak(BlockBreakEvent e) {
        Object value;
        if (this.jobManager.shouldIgnore(e.getPlayer())) {
            return;
        }
        Block block = e.getBlock();
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Ageable) {
            Ageable ageable = (Ageable)blockData;
            value = block.getType().name() + ageable.getAge();
        } else {
            value = block.getType().name();
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.BREAK)) {
            for (Job job : this.jobManager.getJobsWithAction(BuiltInActions.Material.BREAK)) {
                this.jobManager.processAction(e.getPlayer(), BuiltInActions.Material.BREAK, (String)value, job, 1);
            }
        }
    }
}

