/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.listeners.job_actions;

import me.usainsrht.ujobs.managers.JobManager;
import me.usainsrht.ujobs.models.BuiltInActions;
import me.usainsrht.ujobs.models.Job;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;

public class FishListener
implements Listener {
    JobManager jobManager;

    public FishListener(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFish(PlayerFishEvent e) {
        Player player = e.getPlayer();
        if (this.jobManager.shouldIgnore(player)) {
            return;
        }
        if (e.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Entity entity = e.getCaught();
        if (!(entity instanceof Item)) {
            return;
        }
        Item item = (Item)entity;
        String name = item.getItemStack().getType().name();
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.FISH)) {
            for (Job job : this.jobManager.getJobsWithAction(BuiltInActions.Material.FISH)) {
                this.jobManager.processAction(player, BuiltInActions.Material.FISH, name, job, 1);
            }
        }
    }
}

