/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.usainsrht.ujobs.UJobsPlugin;
import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class BossBarManager {
    private final UJobsPlugin plugin;
    private final Map<UUID, Map<String, BossBarData>> playerBossBars;

    public BossBarManager(UJobsPlugin plugin) {
        this.plugin = plugin;
        this.playerBossBars = new ConcurrentHashMap<UUID, Map<String, BossBarData>>();
    }

    public void showBossBar(final Player player, final String key, BossBar bossBar, int durationSeconds) {
        final UUID playerId = player.getUniqueId();
        final Map bossBars = this.playerBossBars.computeIfAbsent(playerId, k -> new HashMap());
        BossBarData existing = (BossBarData)bossBars.get(key);
        if (existing != null) {
            existing.bossBar.progress(bossBar.progress());
            existing.bossBar.name(bossBar.name());
            bossBar = existing.bossBar;
            if (existing.task != null && !existing.task.isCancelled()) {
                existing.task.cancel();
            }
        } else {
            player.showBossBar(bossBar);
        }
        final BossBar finalBossBar = bossBar;
        BukkitTask hideTask = new BukkitRunnable(){

            public void run() {
                BossBarManager.this.hideBossBar(player, finalBossBar);
                bossBars.remove(key);
                if (bossBars.isEmpty()) {
                    BossBarManager.this.playerBossBars.remove(playerId);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)durationSeconds * 20L);
        bossBars.put(key, new BossBarData(bossBar, hideTask));
    }

    public void hideBossBar(Player player, BossBar bossBar) {
        player.hideBossBar(bossBar);
    }

    public void hideBossBar(Player player, String key) {
        UUID playerId = player.getUniqueId();
        Map<String, BossBarData> bossBars = this.playerBossBars.get(playerId);
        if (bossBars != null) {
            BossBarData bossBarData = bossBars.remove(key);
            if (bossBarData != null) {
                this.hideBossBar(player, bossBarData.bossBar);
                if (bossBarData.task != null && !bossBarData.task.isCancelled()) {
                    bossBarData.task.cancel();
                }
            }
            if (bossBars.isEmpty()) {
                this.playerBossBars.remove(playerId);
            }
        }
    }

    public void removePlayerBossBars(Player player) {
        UUID playerId = player.getUniqueId();
        Map<String, BossBarData> bossBars = this.playerBossBars.remove(playerId);
        if (bossBars != null) {
            for (BossBarData bossBarData : bossBars.values()) {
                this.hideBossBar(player, bossBarData.bossBar);
                if (bossBarData.task == null || bossBarData.task.isCancelled()) continue;
                bossBarData.task.cancel();
            }
        }
    }

    public void removeAllBossBars() {
        for (UUID playerId : this.playerBossBars.keySet()) {
            Player player = this.plugin.getServer().getPlayer(playerId);
            if (player == null) continue;
            this.removePlayerBossBars(player);
        }
        this.playerBossBars.clear();
    }

    public boolean hasBossBar(Player player, String key) {
        UUID playerId = player.getUniqueId();
        Map<String, BossBarData> bossBars = this.playerBossBars.get(playerId);
        return bossBars != null && bossBars.containsKey(key);
    }

    public void updateBossBar(Player player, String key, BossBar newBossBar) {
        BossBarData existing;
        UUID playerId = player.getUniqueId();
        Map<String, BossBarData> bossBars = this.playerBossBars.get(playerId);
        if (bossBars != null && (existing = bossBars.get(key)) != null) {
            this.hideBossBar(player, existing.bossBar);
            player.showBossBar(newBossBar);
            bossBars.put(key, new BossBarData(newBossBar, existing.task));
        }
    }

    private static class BossBarData {
        final BossBar bossBar;
        final BukkitTask task;

        BossBarData(BossBar bossBar, BukkitTask task) {
            this.bossBar = bossBar;
            this.task = task;
        }
    }
}

