/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.utils;

import me.usainsrht.ujobs.UJobsPlugin;
import me.usainsrht.ujobs.models.Job;
import me.usainsrht.ujobs.models.PlayerJobData;
import me.usainsrht.ujobs.utils.MessageUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class JobExpUtils {
    public static void processJobExp(Player player, Job job, Job.ActionReward reward, int amount) {
        UJobsPlugin plugin = UJobsPlugin.instance;
        PlayerJobData playerData = plugin.getStorage().getCached(player.getUniqueId());
        PlayerJobData.JobStats stats = playerData.getJobStats(job.getId());
        double expGain = reward.getExp() * (double)amount;
        double moneyGain = reward.getMoney() * (double)amount;
        int currentLevel = stats.getLevel();
        double currentExp = stats.getExp();
        double newExp = currentExp + expGain;
        long requiredExp = job.calculateExpForLevel(currentLevel);
        boolean leveledUp = false;
        int newLevel = currentLevel;
        if (newExp >= (double)requiredExp) {
            leveledUp = true;
            newLevel = currentLevel + 1;
            stats.setLevel(newLevel);
            stats.setExp(newExp -= (double)requiredExp);
            JobExpUtils.handleLevelUp(player, job, newLevel);
        } else {
            stats.setExp(newExp);
        }
        if (moneyGain > 0.0 && plugin.getEconomy() != null) {
            plugin.getEconomy().depositPlayer((OfflinePlayer)player, moneyGain);
            stats.setTotalMoney(stats.getTotalMoney() + moneyGain);
        }
        JobExpUtils.showJobBossBar(player, job, newLevel, newExp, expGain, leveledUp);
    }

    public static void handleLevelUp(Player player, Job job, int newLevel) {
        UJobsPlugin plugin = UJobsPlugin.instance;
        if (job.getLevelEquation() != null) {
            MessageUtil.send((Audience)player, job.getLevelUpMessage());
        }
        JobExpUtils.showLevelUpAnimation(player, job, newLevel);
        plugin.getLeaderboardManager().checkLeaderboardChange(player.getUniqueId(), job, newLevel);
    }

    public static void showJobBossBar(Player player, Job job, int level, double exp, double expGain, boolean leveledUp) {
        UJobsPlugin plugin = UJobsPlugin.instance;
        long requiredExp = job.calculateExpForLevel(level);
        double progress = Math.min(1.0, exp / (double)requiredExp);
        String titleTemplate = job.getBossBarConfig().getTitleTemplate();
        Component title = plugin.getMiniMessage().deserialize(titleTemplate, new TagResolver[]{Formatter.number((String)"level", (Number)level), Placeholder.component((String)"job", (ComponentLike)job.getName()), Placeholder.unparsed((String)"symbol_exp", (String)plugin.getConfig().getString("symbols.exp", "xp")), Formatter.number((String)"gained_exp", (Number)expGain), Formatter.number((String)"exp", (Number)exp), Formatter.number((String)"next_exp", (Number)requiredExp)});
        BossBar bossBar = BossBar.bossBar((Component)title, (float)((float)progress), (BossBar.Color)job.getBossBarConfig().getColor(), (BossBar.Overlay)job.getBossBarConfig().getOverlay());
        plugin.getBossBarManager().showBossBar(player, job.getId(), bossBar, 3);
    }

    public static void showLevelUpAnimation(final Player player, final Job job, final int newLevel) {
        final UJobsPlugin plugin = UJobsPlugin.instance;
        final String levelUpTemplate = job.getBossBarConfig().getLevelUpTemplate();
        new BukkitRunnable(){
            private int ticks = 0;

            public void run() {
                if (this.ticks >= 60) {
                    this.cancel();
                    return;
                }
                double phase = Math.random();
                String animatedTemplate = levelUpTemplate.replace("{phase}", String.valueOf(phase % 1.0));
                Component title = plugin.getMiniMessage().deserialize(animatedTemplate, new TagResolver[]{Placeholder.component((String)"job", (ComponentLike)job.getName()), Formatter.number((String)"level", (Number)newLevel)});
                BossBar levelUpBar = BossBar.bossBar((Component)title, (float)1.0f, (BossBar.Color)job.getBossBarConfig().getColor(), (BossBar.Overlay)job.getBossBarConfig().getOverlay());
                plugin.getBossBarManager().showBossBar(player, job.getId() + "_levelup", levelUpBar, 1);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)plugin, 0L, 1L);
    }

    public int calculatePlayerLevel(String jobId, double experience) {
        double expForNextLevel;
        Job job = UJobsPlugin.instance.getJobManager().getJobs().get(jobId);
        if (job == null) {
            return 0;
        }
        int level = 0;
        double totalExpNeeded = 0.0;
        while (totalExpNeeded <= experience && !(totalExpNeeded + (expForNextLevel = (double)job.calculateExpForLevel(level)) > experience)) {
            totalExpNeeded += expForNextLevel;
            ++level;
        }
        return level;
    }

    public double getExpForCurrentLevel(String jobId, int level, double totalExp) {
        Job job = UJobsPlugin.instance.getJobManager().getJobs().get(jobId);
        if (job == null) {
            return 0.0;
        }
        double expUsed = 0.0;
        for (int i = 0; i < level; ++i) {
            expUsed += (double)job.calculateExpForLevel(i);
        }
        return totalExp - expUsed;
    }
}

