/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import lombok.Generated;
import me.usainsrht.ujobs.UJobsPlugin;
import me.usainsrht.ujobs.gui.JobGUI;
import me.usainsrht.ujobs.gui.JobInfoGUI;
import me.usainsrht.ujobs.gui.LeaderboardGUI;
import me.usainsrht.ujobs.models.Job;
import me.usainsrht.ujobs.models.PlayerJobData;
import me.usainsrht.ujobs.utils.ProgressBarUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class MainJobGUI
implements JobGUI {
    public Inventory inventory;
    public UUID uuid;
    public static final NamespacedKey jobKey = new NamespacedKey("ujobs", "job_id");

    public MainJobGUI(UJobsPlugin plugin, UUID uuid) {
        int rows = (int)Math.ceil((float)plugin.getJobManager().getJobs().size() / 7.0f) + 2;
        Component title = plugin.getMiniMessage().deserialize((Object)plugin.getConfig().getString("gui.title"));
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (Component)title);
        String blankMaterial = plugin.getConfig().getString("gui.blank_material", null);
        if (blankMaterial != null && !blankMaterial.isEmpty() && !blankMaterial.equalsIgnoreCase("air")) {
            ItemStack blankItem = new ItemStack(Material.matchMaterial((String)blankMaterial));
            blankItem.editMeta(meta -> meta.setHideTooltip(true));
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                this.inventory.setItem(i, blankItem);
            }
        }
        if (plugin.getStorage().isCached(uuid)) {
            PlayerJobData playerJobData = plugin.getStorage().getCached(uuid);
            this.fill(plugin, playerJobData);
        } else {
            plugin.getStorage().load(uuid).thenAccept(data -> this.fill(plugin, (PlayerJobData)data));
        }
    }

    public void fill(UJobsPlugin plugin, PlayerJobData playerJobData) {
        int i = 1;
        int baseSlot = 9;
        for (Job job : plugin.getJobManager().getJobs().values()) {
            if (i > 7) {
                baseSlot = 11;
            }
            if (i > 14) {
                baseSlot = 13;
            }
            String jobId = job.getId();
            PlayerJobData.JobStats jobStats = playerJobData.getJobStats(jobId);
            double exp = jobStats.getExp();
            int level = jobStats.getLevel();
            double nextExp = job.calculateExpForLevel(level);
            double totalMoney = jobStats.getTotalMoney();
            String progress = ProgressBarUtil.getProgressBar(exp, nextExp, 25, "", "|", "<color:dark_gray>", "|");
            TextColor primaryColor = ((Component)job.getName().children().getFirst()).color();
            TextColor secondaryColor = ((Component)job.getName().children().getLast()).color();
            HashSet<Object> placeholderSet = new HashSet<Object>();
            placeholderSet.add(Placeholder.component((String)"job", (ComponentLike)job.getName()));
            placeholderSet.add(Formatter.number((String)"level", (Number)level));
            placeholderSet.add(Formatter.number((String)"next_level", (Number)(level + 1)));
            placeholderSet.add(Formatter.number((String)"exp", (Number)exp));
            placeholderSet.add(Formatter.number((String)"next_exp", (Number)nextExp));
            placeholderSet.add(Formatter.number((String)"total_money", (Number)totalMoney));
            placeholderSet.add(Placeholder.parsed((String)"progress", (String)progress));
            placeholderSet.add(Placeholder.parsed((String)"money_symbol", (String)plugin.getConfig().getString("symbols.money")));
            placeholderSet.add(Placeholder.parsed((String)"exp_symbol", (String)plugin.getConfig().getString("symbols.exp")));
            placeholderSet.add(Placeholder.styling((String)"primary", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{primaryColor}));
            placeholderSet.add(Placeholder.styling((String)"secondary", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{secondaryColor}));
            int position = plugin.getLeaderboardManager().getPosition(playerJobData.getUuid(), job);
            String positionText = position == -1 ? plugin.getConfig().getString("leaderboard.calculate_top", "100") + "+" : String.valueOf(position + 1);
            placeholderSet.add(Placeholder.unparsed((String)"position", (String)positionText));
            TagResolver[] placeholders = placeholderSet.toArray(new TagResolver[0]);
            ItemStack item = new ItemStack(job.getIcon());
            item.editMeta(meta -> {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                Component name = plugin.getMiniMessage().deserialize(plugin.getConfig().getString("gui.jobitem.name"), placeholders).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
                meta.displayName(name);
                ArrayList lore = new ArrayList();
                plugin.getConfig().getStringList("gui.jobitem.lore").forEach(line -> {
                    Component component = plugin.getMiniMessage().deserialize(line, placeholders).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
                    lore.add(component);
                });
                meta.lore(lore);
                meta.getPersistentDataContainer().set(jobKey, PersistentDataType.STRING, (Object)jobId);
            });
            int slot = baseSlot + i;
            this.inventory.setItem(slot, item);
            ++i;
        }
    }

    public void open(Player player) {
        player.openInventory(this.inventory);
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void onClick(InventoryClickEvent e) {
        e.setCancelled(true);
        ItemStack itemStack = e.getCurrentItem();
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return;
        }
        if (itemStack.getPersistentDataContainer().has(jobKey)) {
            if (e.getClick().isLeftClick()) {
                new LeaderboardGUI(UJobsPlugin.instance, this.uuid).open((Player)e.getWhoClicked());
            } else if (e.getClick().isRightClick()) {
                new JobInfoGUI(UJobsPlugin.instance).open((Player)e.getWhoClicked());
            }
        }
    }

    @Override
    public void onBottomClick(InventoryClickEvent e) {
    }

    @Override
    public void onDrag(InventoryDragEvent e) {
        e.setCancelled(true);
    }

    @Override
    public void onOpen(InventoryOpenEvent e) {
    }

    @Override
    public void onClose(InventoryCloseEvent e) {
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }
}

