/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.managers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import me.usainsrht.ujobs.UJobsPlugin;
import me.usainsrht.ujobs.models.Job;
import me.usainsrht.ujobs.models.PlayerJobData;
import me.usainsrht.ujobs.models.PlayerLeaderboardData;
import me.usainsrht.ujobs.storage.PDCStorage;
import me.usainsrht.ujobs.storage.Storage;
import me.usainsrht.ujobs.utils.MessageUtil;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.StyleBuilderApplicable;
import net.kyori.adventure.text.minimessage.tag.resolver.Formatter;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class LeaderboardManager {
    UJobsPlugin plugin;
    Map<UUID, PlayerLeaderboardData> leaderboardPlayerCache;
    Map<Job, UUID[]> leaderboardJobCache;

    public LeaderboardManager(UJobsPlugin plugin) {
        this.plugin = plugin;
        this.leaderboardPlayerCache = new HashMap<UUID, PlayerLeaderboardData>();
        this.leaderboardJobCache = new HashMap<Job, UUID[]>();
    }

    public void load(ConfigurationSection yml) {
        for (Job job : this.plugin.getJobManager().getJobs().values()) {
            this.leaderboardJobCache.put(job, new UUID[100]);
        }
        ConfigurationSection leaderboardSection = yml.getConfigurationSection("leaderboard");
        if (leaderboardSection == null) {
            return;
        }
        leaderboardSection.getKeys(false).forEach(jobId -> {
            Job job = this.plugin.getJobManager().getJobs().get(jobId);
            if (job == null) {
                return;
            }
            ConfigurationSection jobSection = yml.getConfigurationSection("leaderboard." + jobId);
            if (jobSection == null) {
                return;
            }
            jobSection.getKeys(false).forEach(uuidString -> {
                UUID uuid = UUID.fromString(uuidString);
                int position = jobSection.getInt(uuidString + ".position", -1);
                int level = jobSection.getInt(uuidString + ".level", -1);
                if (position < 0 || level < 0) {
                    return;
                }
                PlayerLeaderboardData playerData = this.leaderboardPlayerCache.computeIfAbsent(uuid, PlayerLeaderboardData::new);
                playerData.getLeaderboardStats().put(job, new PlayerLeaderboardData.LeaderboardStats(position, level));
                this.leaderboardJobCache.get((Object)job)[position] = uuid;
            });
        });
    }

    public void save() {
        YamlConfiguration leaderboardConfig = this.plugin.getConfigManager().getLeaderboardConfig();
        leaderboardConfig.set("leaderboard", null);
        for (Job job : this.plugin.getJobManager().getJobs().values()) {
            if (this.leaderboardJobCache.containsKey(job) && this.leaderboardJobCache.get(job) != null && this.leaderboardJobCache.get(job)[0] != null) continue;
            this.leaderboardJobCache.put(job, this.createLeaderboard(job));
        }
        this.leaderboardPlayerCache.forEach((uuid, playerLeaderboardData) -> playerLeaderboardData.getLeaderboardStats().forEach((job, stats) -> {
            String path = "leaderboard." + job.getId() + "." + uuid.toString();
            leaderboardConfig.set(path + ".position", (Object)stats.getPosition());
            leaderboardConfig.set(path + ".level", (Object)stats.getLevel());
        }));
        this.plugin.getConfigManager().saveLeaderboard();
    }

    public UUID[] createLeaderboard(Job job) {
        Storage storage = this.plugin.getStorage();
        if (storage instanceof PDCStorage) {
            PDCStorage pdcStorage = (PDCStorage)storage;
            UUID[] leaderboard = new UUID[this.plugin.getConfig().getInt("leaderboard.calculate_top", 100)];
            this.leaderboardJobCache.put(job, leaderboard);
            for (PlayerJobData playerJobData : pdcStorage.getCache().values()) {
                int insertIndex;
                int level = playerJobData.getJobStats(job.getId()).getLevel();
                if (level < 0) continue;
                for (insertIndex = 0; insertIndex < leaderboard.length && leaderboard[insertIndex] != null; ++insertIndex) {
                    UUID existingUuid = leaderboard[insertIndex];
                    int existingLevel = -1;
                    if (existingUuid != null) {
                        PlayerJobData existingPlayerJobData = pdcStorage.getCache().get(existingUuid);
                        if (existingPlayerJobData == null) break;
                        existingLevel = existingPlayerJobData.getJobStats(job.getId()).getLevel();
                    }
                    if (level > existingLevel) break;
                }
                if (insertIndex >= leaderboard.length) continue;
                System.arraycopy(leaderboard, insertIndex, leaderboard, insertIndex + 1, leaderboard.length - insertIndex - 1);
                leaderboard[insertIndex] = playerJobData.getUuid();
                this.leaderboardPlayerCache.computeIfAbsent(playerJobData.getUuid(), PlayerLeaderboardData::new).getLeaderboardStats().put(job, new PlayerLeaderboardData.LeaderboardStats(insertIndex, level));
            }
            return leaderboard;
        }
        return null;
    }

    public int getPosition(UUID uuid, Job job) {
        PlayerLeaderboardData data = this.leaderboardPlayerCache.get(uuid);
        if (data == null) {
            return -1;
        }
        PlayerLeaderboardData.LeaderboardStats stats = data.getLeaderboardStats().get(job);
        if (stats == null) {
            return -1;
        }
        return stats.getPosition();
    }

    public int getLevel(UUID uuid, Job job) {
        PlayerLeaderboardData data = this.leaderboardPlayerCache.get(uuid);
        if (data == null) {
            return -1;
        }
        PlayerLeaderboardData.LeaderboardStats stats = data.getLeaderboardStats().get(job);
        if (stats == null) {
            return -1;
        }
        return stats.getLevel();
    }

    public PlayerLeaderboardData.LeaderboardStats getStats(UUID uuid, Job job) {
        PlayerLeaderboardData data = this.leaderboardPlayerCache.get(uuid);
        if (data == null) {
            return null;
        }
        return data.getLeaderboardStats().get(job);
    }

    public UUID getPlayerByPosition(int position, Job job) {
        if (position < 0) {
            return null;
        }
        UUID[] leaderboard = this.leaderboardJobCache.get(job);
        if (leaderboard == null || position >= leaderboard.length) {
            return null;
        }
        return leaderboard[position];
    }

    public void checkLeaderboardChange(UUID uuid, Job job, int level) {
        int oneHigher;
        UUID opponent;
        int position = this.getPosition(uuid, job);
        int calculateTop = this.plugin.getConfig().getInt("leaderboard.calculate_top", 100);
        if (position == -1) {
            opponent = null;
            for (oneHigher = calculateTop - 1; oneHigher >= 0 && ((opponent = this.getPlayerByPosition(oneHigher, job)) == null || opponent.equals(uuid)); --oneHigher) {
            }
        } else {
            this.leaderboardPlayerCache.get(uuid).getLeaderboardStats().get(job).setLevel(level);
            oneHigher = position - 1;
            if (oneHigher < 0) {
                return;
            }
            opponent = this.getPlayerByPosition(oneHigher, job);
        }
        if (opponent == null) {
            return;
        }
        if (opponent.equals(uuid)) {
            return;
        }
        int opponentLevel = this.leaderboardPlayerCache.get(opponent).getLeaderboardStats().get(job).getLevel();
        if (level > opponentLevel) {
            this.leaderboardPlayerCache.computeIfAbsent(uuid, PlayerLeaderboardData::new).getLeaderboardStats().computeIfAbsent(job, k -> new PlayerLeaderboardData.LeaderboardStats(-1, 0)).setPosition(oneHigher);
            this.leaderboardPlayerCache.get(uuid).getLeaderboardStats().get(job).setLevel(level);
            this.leaderboardPlayerCache.get(opponent).getLeaderboardStats().get(job).setPosition(position);
            this.leaderboardJobCache.get((Object)job)[oneHigher] = uuid;
            if (position != -1) {
                this.leaderboardJobCache.get((Object)job)[position] = opponent;
            }
            OfflinePlayer opponentPlayer = Bukkit.getOfflinePlayer((UUID)opponent);
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
            HashSet<Object> placeholderSet = new HashSet<Object>();
            placeholderSet.add(Placeholder.component((String)"opponent_displayname", (ComponentLike)(opponentPlayer.isOnline() ? opponentPlayer.getPlayer().displayName() : Component.text((String)opponentPlayer.getName()))));
            placeholderSet.add(Placeholder.unparsed((String)"opponent_name", (String)opponentPlayer.getName()));
            placeholderSet.add(Placeholder.component((String)"displayname", (ComponentLike)(player.isOnline() ? player.getPlayer().displayName() : Component.text((String)player.getName()))));
            placeholderSet.add(Placeholder.unparsed((String)"name", (String)player.getName()));
            placeholderSet.add(Formatter.number((String)"level", (Number)level));
            placeholderSet.add(Formatter.number((String)"position", (Number)(oneHigher + 1)));
            placeholderSet.add(Placeholder.component((String)"job", (ComponentLike)job.getName()));
            placeholderSet.add(Placeholder.styling((String)"primary", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{((Component)job.getName().children().getFirst()).color()}));
            placeholderSet.add(Placeholder.styling((String)"secondary", (StyleBuilderApplicable[])new StyleBuilderApplicable[]{((Component)job.getName().children().getLast()).color()}));
            TagResolver[] placeholders = placeholderSet.toArray(new TagResolver[0]);
            if (player.isOnline()) {
                MessageUtil.send((Audience)player.getPlayer(), this.plugin.getConfigManager().getMessage("leaderboard_take_someones_position"), placeholders);
            }
            if (opponentPlayer.isOnline()) {
                MessageUtil.send((Audience)opponentPlayer.getPlayer(), this.plugin.getConfigManager().getMessage("leaderboard_your_position_taken"), placeholders);
            }
            if (oneHigher == 0) {
                MessageUtil.send((Audience)this.plugin.getServer(), this.plugin.getConfigManager().getMessage("leaderboard_take_lead"), placeholders);
            } else if (oneHigher == 9) {
                MessageUtil.send((Audience)this.plugin.getServer(), this.plugin.getConfigManager().getMessage("leaderboard_get_in_top_10"), placeholders);
            }
            this.save();
        } else {
            UUID[] leaderboard;
            int belowOpponent = oneHigher + 1;
            if (belowOpponent < calculateTop && belowOpponent > 0 && (leaderboard = this.leaderboardJobCache.get(job))[belowOpponent] == null) {
                leaderboard[belowOpponent] = uuid;
                this.leaderboardPlayerCache.computeIfAbsent(uuid, PlayerLeaderboardData::new).getLeaderboardStats().computeIfAbsent(job, k -> new PlayerLeaderboardData.LeaderboardStats(-1, 0)).setPosition(belowOpponent);
                this.leaderboardPlayerCache.get(uuid).getLeaderboardStats().get(job).setLevel(level);
                this.save();
            }
        }
    }

    @Generated
    public UJobsPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public Map<UUID, PlayerLeaderboardData> getLeaderboardPlayerCache() {
        return this.leaderboardPlayerCache;
    }

    @Generated
    public Map<Job, UUID[]> getLeaderboardJobCache() {
        return this.leaderboardJobCache;
    }
}

