/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import me.usainsrht.ujobs.UJobsPlugin;
import me.usainsrht.ujobs.models.PlayerJobData;
import me.usainsrht.ujobs.storage.Storage;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class PDCStorage
implements Storage {
    UJobsPlugin plugin;
    HashMap<UUID, PlayerJobData> cache;
    public static final NamespacedKey TAG_JOBS_DATA = new NamespacedKey("ujobs", "jobs_data");
    public static final NamespacedKey TAG_LEVEL = new NamespacedKey("ujobs", "level");
    public static final NamespacedKey TAG_EXP = new NamespacedKey("ujobs", "exp");
    public static final NamespacedKey TAG_TOTAL_MONEY = new NamespacedKey("ujobs", "total_money");

    public PDCStorage(UJobsPlugin plugin) {
        this.plugin = plugin;
        this.cache = new HashMap();
    }

    public PersistentDataContainer serialize(PersistentDataAdapterContext context, PlayerJobData playerJobData) {
        PersistentDataContainer container = context.newPersistentDataContainer();
        for (Map.Entry<String, PlayerJobData.JobStats> entry : playerJobData.getJobStats().entrySet()) {
            PlayerJobData.JobStats jobStats = entry.getValue();
            if (jobStats.getExp() == 0.0 && jobStats.getLevel() == 0 && jobStats.getTotalMoney() == 0.0) continue;
            NamespacedKey jobKey = NamespacedKey.fromString((String)entry.getKey(), (Plugin)this.plugin);
            PersistentDataContainer jobContainer = this.serialize(context, jobStats);
            container.set(jobKey, PersistentDataType.TAG_CONTAINER, (Object)jobContainer);
        }
        return container;
    }

    public PersistentDataContainer serialize(PersistentDataAdapterContext context, PlayerJobData.JobStats jobStats) {
        PersistentDataContainer container = context.newPersistentDataContainer();
        container.set(TAG_LEVEL, PersistentDataType.INTEGER, (Object)jobStats.getLevel());
        container.set(TAG_EXP, PersistentDataType.DOUBLE, (Object)jobStats.getExp());
        container.set(TAG_TOTAL_MONEY, PersistentDataType.DOUBLE, (Object)jobStats.getTotalMoney());
        return container;
    }

    public PlayerJobData deserialize(UUID uuid, PersistentDataContainer pdc) {
        PlayerJobData playerJobData = new PlayerJobData(uuid);
        for (NamespacedKey jobKey : pdc.getKeys()) {
            if (!pdc.has(jobKey, PersistentDataType.TAG_CONTAINER)) continue;
            PersistentDataContainer jobContainer = (PersistentDataContainer)pdc.get(jobKey, PersistentDataType.TAG_CONTAINER);
            PlayerJobData.JobStats jobStats = this.deserializeJobStats(jobContainer);
            playerJobData.setJobStats(jobKey.getKey(), jobStats);
        }
        return playerJobData;
    }

    public PlayerJobData.JobStats deserializeJobStats(PersistentDataContainer jobContainer) {
        int level = (Integer)jobContainer.get(TAG_LEVEL, PersistentDataType.INTEGER);
        double exp = (Double)jobContainer.get(TAG_EXP, PersistentDataType.DOUBLE);
        double totalMoney = (Double)jobContainer.get(TAG_TOTAL_MONEY, PersistentDataType.DOUBLE);
        return new PlayerJobData.JobStats(level, exp, totalMoney);
    }

    @Override
    public void save() {
        for (UUID uuid : this.cache.keySet()) {
            this.save(uuid);
        }
    }

    @Override
    public void save(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            PlayerJobData playerJobData = this.getCached(uuid);
            if (playerJobData == null) {
                return;
            }
            this.set(player, playerJobData);
        }
    }

    @Override
    public CompletableFuture<PlayerJobData> load(UUID uuid) {
        CompletableFuture<PlayerJobData> future = new CompletableFuture<PlayerJobData>();
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            player.getScheduler().run((Plugin)this.plugin, task -> {
                PersistentDataContainer pdc = player.getPersistentDataContainer();
                PlayerJobData playerJobData = pdc.has(TAG_JOBS_DATA) ? this.deserialize(uuid, (PersistentDataContainer)pdc.get(TAG_JOBS_DATA, PersistentDataType.TAG_CONTAINER)) : new PlayerJobData(uuid);
                this.cache.put(uuid, playerJobData);
                future.complete(playerJobData);
            }, () -> {
                this.plugin.getLogger().warning("Can't load data of " + String.valueOf(uuid) + "! storage: PDC");
                future.cancel(false);
            });
        }
        return future;
    }

    @Override
    public boolean isCached(UUID uuid) {
        return this.cache.containsKey(uuid);
    }

    @Override
    @Nullable
    public PlayerJobData getCached(UUID uuid) {
        return this.cache.getOrDefault(uuid, null);
    }

    @Override
    public void set(UUID uuid, PlayerJobData playerJobData) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || !player.isOnline()) {
            return;
        }
        this.cache.put(uuid, playerJobData);
        this.set(player, playerJobData);
    }

    private void set(Player player, PlayerJobData playerJobData) {
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        pdc.set(TAG_JOBS_DATA, PersistentDataType.TAG_CONTAINER, (Object)this.serialize(pdc.getAdapterContext(), playerJobData));
    }

    @Override
    public void remove(UUID uuid) {
        this.removeFromCache(uuid);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null || !player.isOnline()) {
            return;
        }
        PersistentDataContainer pdc = player.getPersistentDataContainer();
        pdc.remove(TAG_JOBS_DATA);
    }

    @Override
    public void removeFromCache(UUID uuid) {
        this.cache.remove(uuid);
    }

    @Generated
    public UJobsPlugin getPlugin() {
        return this.plugin;
    }

    @Generated
    public HashMap<UUID, PlayerJobData> getCache() {
        return this.cache;
    }
}

