/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.logging.Level;
import lombok.Generated;
import me.usainsrht.ujobs.commands.MainCommand;
import me.usainsrht.ujobs.listeners.InventoryListener;
import me.usainsrht.ujobs.listeners.JoinListener;
import me.usainsrht.ujobs.listeners.QuitListener;
import me.usainsrht.ujobs.listeners.SaveListener;
import me.usainsrht.ujobs.listeners.job_actions.AnvilMergeListener;
import me.usainsrht.ujobs.listeners.job_actions.BreakListener;
import me.usainsrht.ujobs.listeners.job_actions.BreedListener;
import me.usainsrht.ujobs.listeners.job_actions.CraftListener;
import me.usainsrht.ujobs.listeners.job_actions.EnchantListener;
import me.usainsrht.ujobs.listeners.job_actions.FishListener;
import me.usainsrht.ujobs.listeners.job_actions.HarvestListener;
import me.usainsrht.ujobs.listeners.job_actions.KillListener;
import me.usainsrht.ujobs.listeners.job_actions.LootGenerateListener;
import me.usainsrht.ujobs.listeners.job_actions.PlaceListener;
import me.usainsrht.ujobs.listeners.job_actions.RaidListener;
import me.usainsrht.ujobs.listeners.job_actions.TameListener;
import me.usainsrht.ujobs.listeners.job_actions.TradeListener;
import me.usainsrht.ujobs.listeners.job_actions.TreeFallListener;
import me.usainsrht.ujobs.managers.BossBarManager;
import me.usainsrht.ujobs.managers.ConfigManager;
import me.usainsrht.ujobs.managers.JobGUIManager;
import me.usainsrht.ujobs.managers.JobManager;
import me.usainsrht.ujobs.managers.LeaderboardManager;
import me.usainsrht.ujobs.managers.NPCManager;
import me.usainsrht.ujobs.models.BuiltInActions;
import me.usainsrht.ujobs.storage.PDCStorage;
import me.usainsrht.ujobs.storage.Storage;
import me.usainsrht.ujobs.yaml.YamlCommand;
import me.usainsrht.ujobs.yaml.YamlMessage;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class UJobsPlugin
extends JavaPlugin {
    public static UJobsPlugin instance;
    private MiniMessage miniMessage;
    private Economy economy;
    private Storage storage;
    private ConfigManager configManager;
    private JobManager jobManager;
    private LeaderboardManager leaderboardManager;
    private JobGUIManager guiManager;
    private BossBarManager bossBarManager;
    private NPCManager npcManager;

    public void onEnable() {
        instance = this;
        this.miniMessage = MiniMessage.miniMessage();
        this.setupEconomy();
        this.storage = new PDCStorage(this);
        this.initializeManagers();
        this.registerEventsAndCommands();
        this.startLeaderboardTimer();
        this.getLogger().info("UJobs has been enabled successfully!");
    }

    public void onDisable() {
        if (this.storage != null) {
            this.storage.save();
        }
        if (this.leaderboardManager != null) {
            this.leaderboardManager.save();
        }
        if (this.configManager != null) {
            this.configManager.saveLeaderboard();
        }
        if (this.bossBarManager != null) {
            this.bossBarManager.removeAllBossBars();
        }
        this.getLogger().info("UJobs has been disabled!");
    }

    private void initializeManagers() {
        try {
            this.configManager = new ConfigManager(this);
            this.jobManager = new JobManager(this);
            this.leaderboardManager = new LeaderboardManager(this);
            this.bossBarManager = new BossBarManager(this);
            this.guiManager = new JobGUIManager(this);
            this.npcManager = new NPCManager(this);
            this.configManager.loadConfigs();
            this.jobManager.loadJobs();
            this.leaderboardManager.load((ConfigurationSection)this.configManager.getLeaderboardConfig());
            this.getLogger().info("All managers initialized successfully!");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize managers", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void registerEventsAndCommands() {
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new QuitListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SaveListener(this), (Plugin)this);
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.BREAK)) {
            this.getServer().getPluginManager().registerEvents((Listener)new BreakListener(this.jobManager), (Plugin)this);
            if (this.getServer().getPluginManager().isPluginEnabled("UltimateTimber")) {
                this.getServer().getPluginManager().registerEvents((Listener)new TreeFallListener(this.jobManager), (Plugin)this);
            }
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.PLACE)) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlaceListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Entity.TAME)) {
            this.getServer().getPluginManager().registerEvents((Listener)new TameListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Entity.BREED)) {
            this.getServer().getPluginManager().registerEvents((Listener)new BreedListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Entity.KILL)) {
            this.getServer().getPluginManager().registerEvents((Listener)new KillListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Special.ENCHANT)) {
            this.getServer().getPluginManager().registerEvents((Listener)new EnchantListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.FISH)) {
            this.getServer().getPluginManager().registerEvents((Listener)new FishListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Special.RAID)) {
            this.getServer().getPluginManager().registerEvents((Listener)new RaidListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Special.GENERATE_LOOT)) {
            this.getServer().getPluginManager().registerEvents((Listener)new LootGenerateListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.TRADE)) {
            this.getServer().getPluginManager().registerEvents((Listener)new TradeListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.ANVIL_MERGE)) {
            this.getServer().getPluginManager().registerEvents((Listener)new AnvilMergeListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.CRAFT)) {
            this.getServer().getPluginManager().registerEvents((Listener)new CraftListener(this.jobManager), (Plugin)this);
        }
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.HARVEST)) {
            this.getServer().getPluginManager().registerEvents((Listener)new HarvestListener(this.jobManager), (Plugin)this);
        }
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            YamlCommand mainCommand = YamlCommand.builder().name(this.getConfig().getString("command.name", "ujobs")).description(this.getConfig().getString("command.description", "UJobs main command")).aliases(this.getConfig().getStringList("command.aliases")).permission(this.getConfig().getString("command.permission", "ujobs.command.main")).permissionMessage(new YamlMessage(this.getConfig().get("command.permission_message"))).build();
            commands.register(this.getPluginMeta(), MainCommand.create(this, mainCommand), mainCommand.getDescription(), mainCommand.getAliases());
        });
    }

    private void setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
            if (rsp == null) {
                return;
            }
            this.economy = (Economy)rsp.getProvider();
        }
    }

    private void startLeaderboardTimer() {
        new BukkitRunnable(this){

            public void run() {
            }
        }.runTaskTimerAsynchronously((Plugin)this, 2400L, 72000L);
    }

    @Generated
    public MiniMessage getMiniMessage() {
        return this.miniMessage;
    }

    @Generated
    public Economy getEconomy() {
        return this.economy;
    }

    @Generated
    public Storage getStorage() {
        return this.storage;
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public JobManager getJobManager() {
        return this.jobManager;
    }

    @Generated
    public LeaderboardManager getLeaderboardManager() {
        return this.leaderboardManager;
    }

    @Generated
    public JobGUIManager getGuiManager() {
        return this.guiManager;
    }

    @Generated
    public BossBarManager getBossBarManager() {
        return this.bossBarManager;
    }

    @Generated
    public NPCManager getNpcManager() {
        return this.npcManager;
    }
}

