/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.listeners.job_actions;

import me.usainsrht.ujobs.managers.JobManager;
import me.usainsrht.ujobs.models.BuiltInActions;
import me.usainsrht.ujobs.models.Job;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CraftListener
implements Listener {
    JobManager jobManager;

    public CraftListener(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraft(CraftItemEvent e) {
        if (this.jobManager.getActionJobMap().containsKey(BuiltInActions.Material.CRAFT)) {
            Player player = (Player)e.getWhoClicked();
            ItemStack result = e.getRecipe().getResult();
            int amount = switch (e.getAction()) {
                case InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF, InventoryAction.DROP_ONE_SLOT, InventoryAction.DROP_ALL_SLOT -> result.getAmount();
                case InventoryAction.MOVE_TO_OTHER_INVENTORY -> {
                    if (CraftListener.getRemainingSpace((Inventory)player.getInventory(), result.asOne()) > 0) {
                        ItemStack[] matrix;
                        int lowest = 127;
                        for (ItemStack item : matrix = e.getInventory().getMatrix()) {
                            int count;
                            if (item == null || item.isEmpty() || (count = item.getAmount()) >= lowest) continue;
                            lowest = count;
                        }
                        yield lowest * result.getAmount();
                    }
                    yield 0;
                }
                default -> 0;
            };
            if (amount <= 0) {
                return;
            }
            for (Job job : this.jobManager.getJobsWithAction(BuiltInActions.Material.CRAFT)) {
                this.jobManager.processAction(player, BuiltInActions.Material.CRAFT, result.getType().name(), job, amount);
            }
        }
    }

    public static int getRemainingSpace(Inventory inventory, ItemStack item) {
        int space = 0;
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack itemStack = inventory.getItem(i);
            if (itemStack == null || itemStack.isEmpty()) {
                space += item.getMaxStackSize();
                continue;
            }
            if (!item.isSimilar(itemStack)) continue;
            space += item.getMaxStackSize() - itemStack.getAmount();
        }
        return space;
    }
}

