/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import me.usainsrht.ujobs.models.Action;
import me.usainsrht.ujobs.models.JobInfoLine;
import me.usainsrht.ujobs.utils.MathUtil;
import me.usainsrht.ujobs.yaml.YamlMessage;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;

public class Job {
    private final String id;
    private Component name;
    private Material icon;
    private String levelEquation;
    private YamlMessage levelUpMessage;
    private BossBarConfig bossBarConfig;
    private final Map<Action, Map<String, ActionReward>> actions;
    private final List<JobInfoLine> infoLines;

    public Job(String id, Component name, Material icon, String levelEquation, YamlMessage levelUpMessage, BossBarConfig bossBarConfig) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.levelEquation = levelEquation;
        this.levelUpMessage = levelUpMessage;
        this.bossBarConfig = bossBarConfig;
        this.actions = new HashMap<Action, Map<String, ActionReward>>();
        this.infoLines = new ArrayList<JobInfoLine>();
    }

    public void update(Job otherJobInstance) {
        if (otherJobInstance == null || !this.id.equalsIgnoreCase(otherJobInstance.id)) {
            return;
        }
        this.name = otherJobInstance.name;
        this.icon = otherJobInstance.icon;
        this.levelEquation = otherJobInstance.levelEquation;
        this.levelUpMessage = otherJobInstance.levelUpMessage;
        this.bossBarConfig = otherJobInstance.bossBarConfig;
        this.actions.clear();
        this.actions.putAll(otherJobInstance.actions);
        this.infoLines.clear();
        this.infoLines.addAll(otherJobInstance.infoLines);
    }

    public void addAction(Action action, String value, ActionReward reward) {
        this.actions.computeIfAbsent(action, k -> new HashMap()).put(value, reward);
    }

    public ActionReward getActionReward(Action action, String value) {
        Map<String, ActionReward> actionMap = this.actions.get(action);
        return actionMap != null ? actionMap.get(value) : null;
    }

    public long calculateExpForLevel(int level) {
        String equation = this.levelEquation.replace("<level>", String.valueOf(level)).replace("<next_level>", String.valueOf(level + 1));
        try {
            return (long)this.evaluateExpression(equation);
        }
        catch (Exception e) {
            return (long)Math.pow(level + 1, 2.0) * 5L;
        }
    }

    private double evaluateExpression(String expression) {
        try {
            return MathUtil.eval(expression);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid expression: " + expression, e);
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Component getName() {
        return this.name;
    }

    @Generated
    public Material getIcon() {
        return this.icon;
    }

    @Generated
    public String getLevelEquation() {
        return this.levelEquation;
    }

    @Generated
    public YamlMessage getLevelUpMessage() {
        return this.levelUpMessage;
    }

    @Generated
    public BossBarConfig getBossBarConfig() {
        return this.bossBarConfig;
    }

    @Generated
    public Map<Action, Map<String, ActionReward>> getActions() {
        return this.actions;
    }

    @Generated
    public List<JobInfoLine> getInfoLines() {
        return this.infoLines;
    }

    public static class BossBarConfig {
        private final String titleTemplate;
        private final String levelUpTemplate;
        private final BossBar.Color color;
        private final BossBar.Overlay overlay;

        public BossBarConfig(String titleTemplate, String levelUpTemplate, BossBar.Color color, BossBar.Overlay overlay) {
            this.titleTemplate = titleTemplate;
            this.levelUpTemplate = levelUpTemplate;
            this.color = color;
            this.overlay = overlay;
        }

        @Generated
        public String getTitleTemplate() {
            return this.titleTemplate;
        }

        @Generated
        public String getLevelUpTemplate() {
            return this.levelUpTemplate;
        }

        @Generated
        public BossBar.Color getColor() {
            return this.color;
        }

        @Generated
        public BossBar.Overlay getOverlay() {
            return this.overlay;
        }
    }

    public static class ActionReward {
        private final double exp;
        private final double money;

        public ActionReward(double exp, double money) {
            this.exp = exp;
            this.money = money;
        }

        @Generated
        public double getExp() {
            return this.exp;
        }

        @Generated
        public double getMoney() {
            return this.money;
        }
    }
}

