/*
 * Decompiled with CFR 0.152.
 */
package me.usainsrht.ujobs.yaml;

import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import me.usainsrht.ujobs.yaml.YamlTitle;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.configuration.ConfigurationSection;

public class YamlMessage {
    private Collection<String> chatMessages;
    private String actionBarMessage;
    private YamlTitle title;
    private Collection<Sound> sounds;

    public YamlMessage(Object obj) {
        if (obj instanceof String || obj instanceof Collection) {
            this.chatMessages = YamlMessage.getMessages(obj);
        } else if (obj instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)obj;
            if (config.isSet("chat")) {
                this.chatMessages = YamlMessage.getMessages(config.get("chat"));
            }
            if (config.isSet("action_bar")) {
                this.actionBarMessage = config.getString("action_bar");
            }
            if (config.isSet("title")) {
                this.title = YamlTitle.getTitle(config.get("title"));
            }
            if (config.isSet("sound")) {
                this.sounds = YamlMessage.getSounds(config.get("sound"));
            }
        } else if (obj instanceof YamlMessage) {
            YamlMessage other = (YamlMessage)obj;
            this.chatMessages = other.chatMessages;
            this.actionBarMessage = other.actionBarMessage;
            this.title = other.title;
            this.sounds = other.sounds;
        }
    }

    public static Collection<String> getMessages(Object object) {
        ArrayList<String> messages = new ArrayList<String>();
        if (object instanceof String) {
            messages.add((String)object);
        } else if (object instanceof Collection) {
            messages.addAll((Collection)object);
        }
        return messages;
    }

    public static Collection<Sound> getSounds(Object object) {
        ArrayList<Sound> sounds = new ArrayList<Sound>();
        if (object instanceof String) {
            String string = (String)object;
            sounds.add(YamlMessage.getSound(string));
        } else if (object instanceof Collection) {
            Collection strings = (Collection)object;
            sounds.addAll(strings.stream().map(YamlMessage::getSound).toList());
        } else if (object instanceof ConfigurationSection) {
            ConfigurationSection config = (ConfigurationSection)object;
            Sound.Builder builder = Sound.sound();
            if (config.isSet("name")) {
                builder.type(Key.key((String)config.getString("name")));
            }
            if (config.isSet("volume")) {
                builder.volume((float)config.getDouble("volume"));
            }
            if (config.isSet("pitch")) {
                builder.pitch((float)config.getDouble("pitch"));
            }
            if (config.isSet("seed")) {
                builder.seed(config.getLong("seed"));
            }
            if (config.isSet("source")) {
                builder.source(Sound.Source.valueOf((String)config.getString("source")));
            }
            sounds.add((Sound)builder.build());
        }
        return sounds;
    }

    public static Sound getSound(String string) {
        Sound.Builder sound = Sound.sound();
        String[] splitted = string.split(",");
        sound.type(Key.key((String)splitted[0]));
        if (splitted.length > 1) {
            sound.volume(Float.parseFloat(splitted[1]));
            if (splitted.length > 2) {
                sound.pitch(Float.parseFloat(splitted[2]));
                if (splitted.length > 3) {
                    sound.seed(Long.parseLong(splitted[3]));
                    if (splitted.length > 4) {
                        sound.source(Sound.Source.valueOf((String)splitted[4]));
                    }
                }
            }
        }
        return (Sound)sound.build();
    }

    @Generated
    public void setChatMessages(Collection<String> chatMessages) {
        this.chatMessages = chatMessages;
    }

    @Generated
    public void setActionBarMessage(String actionBarMessage) {
        this.actionBarMessage = actionBarMessage;
    }

    @Generated
    public void setTitle(YamlTitle title) {
        this.title = title;
    }

    @Generated
    public void setSounds(Collection<Sound> sounds) {
        this.sounds = sounds;
    }

    @Generated
    public Collection<String> getChatMessages() {
        return this.chatMessages;
    }

    @Generated
    public String getActionBarMessage() {
        return this.actionBarMessage;
    }

    @Generated
    public YamlTitle getTitle() {
        return this.title;
    }

    @Generated
    public Collection<Sound> getSounds() {
        return this.sounds;
    }
}

