/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.config;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigScreen {
    public static Screen buildScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.literal((String)"More Cobblemon Tweaks"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory pcCategory = builder.getOrCreateCategory((Component)Component.literal((String)"Pc Enhancements"));
        ConfigCategory loreCategory = builder.getOrCreateCategory((Component)Component.literal((String)"Lore Enhancements"));
        pcCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "pc_iv_display"));
        pcCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "pc_colored_ivs", "pc_iv_display"));
        pcCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "pc_multi_select"));
        loreCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "enhanced_egg_lore"));
        loreCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "egg_encryption_warning", "enhanced_egg_lore"));
        loreCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "shiny_egg_indicator", "enhanced_egg_lore"));
        loreCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "perfect_iv_egg_indicator", "enhanced_egg_lore"));
        loreCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "minimum_iv_egg_indicator", "enhanced_egg_lore"));
        loreCategory.addEntry(ConfigScreen.basicToggle(entryBuilder, "text_egg_indicators", "enhanced_egg_lore"));
        builder.setSavingRunnable(ModConfig::saveConfig);
        return builder.build();
    }

    private static AbstractConfigListEntry<?> basicToggle(ConfigEntryBuilder builder, String key) {
        return ConfigScreen.basicToggle(builder, key, (BooleanToggleBuilder entry) -> {});
    }

    private static AbstractConfigListEntry<?> basicToggle(ConfigEntryBuilder builder, String key, String requires) {
        return ConfigScreen.basicToggle(builder, key, (BooleanToggleBuilder entry) -> ((BooleanToggleBuilder)entry.setRequirement(() -> ModConfig.isEnabled(requires) && !ModConfig.serverOverride(key))).setTooltipSupplier(() -> {
            if (ModConfig.serverOverride(key)) {
                return Optional.of(new Component[]{Component.translatable((String)"more_cobblemon_tweaks.config.option.overridden_tooltip")});
            }
            if (!ModConfig.isEnabled(requires)) {
                return Optional.of(new Component[]{Component.translatable((String)("more_cobblemon_tweaks.config.option." + key + ".requirements"))});
            }
            return Optional.of(new Component[]{Component.translatable((String)("more_cobblemon_tweaks.config.option." + key + ".tooltip"))});
        }));
    }

    private static AbstractConfigListEntry<?> basicToggle(ConfigEntryBuilder builder, String key, Consumer<BooleanToggleBuilder> unique) {
        BooleanToggleBuilder entry = ((BooleanToggleBuilder)builder.startBooleanToggle((Component)Component.translatable((String)("more_cobblemon_tweaks.config.option." + key)), ModConfig.isEnabled(key)).setRequirement(() -> !ModConfig.serverOverride(key))).setDefaultValue(ModConfig.getDefault(key)).setTooltipSupplier(ConfigScreen.tooltip(key)).setSaveConsumer(value -> ModConfig.setEnabled(key, value));
        unique.accept(entry);
        return entry.build();
    }

    private static Supplier<Optional<Component[]>> tooltip(String key) {
        return () -> {
            if (ModConfig.serverOverride(key)) {
                return Optional.of(new Component[]{Component.translatable((String)"more_cobblemon_tweaks.config.option.overridden_tooltip")});
            }
            return Optional.of(new Component[]{Component.translatable((String)("more_cobblemon_tweaks.config.option." + key + ".tooltip"))});
        };
    }
}

