/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.justahuman.more_cobblemon_tweaks.MoreCobblemonTweaks;

public class ModConfig {
    private static final Gson GSON = new Gson().newBuilder().setPrettyPrinting().create();
    private static final JsonObject INTERNAL_CONFIG = new JsonObject();
    private static final JsonObject SERVER_CONFIG = new JsonObject();
    private static final JsonObject DEFAULT_CONFIG = new JsonObject();

    public static void loadFromFile() {
        INTERNAL_CONFIG.asMap().clear();
        try (FileReader reader = new FileReader(ModConfig.getConfigFile());){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                jsonObject.entrySet().forEach(entry -> INTERNAL_CONFIG.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            }
        }
        catch (Exception e) {
            MoreCobblemonTweaks.LOGGER.warn("Error occurred while loading Config!");
            MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
        }
    }

    public static void clearServerConfig() {
        SERVER_CONFIG.asMap().clear();
    }

    public static void loadServerConfig(BufferedReader reader) {
        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            jsonObject.entrySet().forEach(entry -> SERVER_CONFIG.add((String)entry.getKey(), (JsonElement)entry.getValue()));
        }
    }

    public static boolean serverOverride(String option) {
        JsonPrimitive primitive;
        JsonElement jsonElement = SERVER_CONFIG.get(option);
        return jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean();
    }

    public static boolean isEnabled(String option) {
        JsonPrimitive primitive;
        JsonElement jsonElement = SERVER_CONFIG.get(option);
        if (jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean()) {
            return primitive.getAsBoolean();
        }
        jsonElement = INTERNAL_CONFIG.get(option);
        return jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean() ? primitive.getAsBoolean() : DEFAULT_CONFIG.get(option).getAsBoolean();
    }

    public static void setEnabled(String key, boolean value) {
        INTERNAL_CONFIG.addProperty(key, Boolean.valueOf(value));
    }

    public static void saveConfig() {
        try (FileWriter fileWriter = new FileWriter(ModConfig.getConfigFile());){
            GSON.toJson((JsonElement)INTERNAL_CONFIG, (Appendable)fileWriter);
            fileWriter.flush();
        }
        catch (IOException e) {
            MoreCobblemonTweaks.LOGGER.warn("Error occurred while saving config!");
            MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
        }
    }

    public static File getConfigFile() {
        File configFile = MoreCobblemonTweaks.getConfigFile();
        if (!configFile.exists()) {
            try {
                configFile.getParentFile().mkdirs();
                if (!configFile.createNewFile()) {
                    throw new IOException();
                }
            }
            catch (IOException | SecurityException e) {
                MoreCobblemonTweaks.LOGGER.warn("Failed to create config file!");
                MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
            }
        }
        return configFile;
    }

    public static boolean getDefault(String key) {
        JsonPrimitive primitive;
        JsonElement jsonElement = DEFAULT_CONFIG.get(key);
        return jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean() && primitive.getAsBoolean();
    }

    static {
        DEFAULT_CONFIG.addProperty("enhanced_egg_lore", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("egg_encryption_warning", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("shiny_egg_indicator", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("perfect_iv_egg_indicator", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("minimum_iv_egg_indicator", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("text_egg_indicators", Boolean.valueOf(false));
        DEFAULT_CONFIG.addProperty("pc_multi_select", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_iv_display", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_colored_ivs", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("open_box_history", Boolean.valueOf(true));
    }
}

