/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features;

import java.awt.Color;
import java.util.List;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;

public class LoreEnhancements {
    private static final String BASE_KEY = "more_cobblemon_tweaks.lore_enhancements.";

    public static void enhanceEggLore(List<Component> lore, List<Component> newLore, EnhancedEggLore enhancedEggLore) {
        Component name = enhancedEggLore.getName(lore);
        boolean shiny = ModConfig.isEnabled("shiny_egg_indicator") && enhancedEggLore.isShiny();
        boolean perfect = ModConfig.isEnabled("perfect_iv_egg_indicator") && enhancedEggLore.hasIVs(31);
        boolean minimum = ModConfig.isEnabled("minimum_iv_egg_indicator") && enhancedEggLore.hasIVs(0);
        boolean textIndicators = ModConfig.isEnabled("text_egg_indicators");
        if (shiny && !textIndicators) {
            name = name.copy().append((Component)LoreEnhancements.translate("egg.shiny.symbol", new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
        if (perfect && !textIndicators) {
            name = name.copy().append((Component)LoreEnhancements.translate("egg.perfect.symbol", new Object[0]).withStyle(ChatFormatting.AQUA));
        } else if (minimum && !textIndicators) {
            name = name.copy().append((Component)LoreEnhancements.translate("egg.minimum.symbol", new Object[0]).withStyle(ChatFormatting.RED));
        }
        String gender = enhancedEggLore.getGender();
        if (gender != null && (gender.equals("MALE") || gender.equals("FEMALE"))) {
            boolean male = gender.equals("MALE");
            name = name.copy().append((Component)Component.literal((String)(male ? " \u2642" : " \u2640")).withStyle(style -> style.withColor(male ? 3329023 : 16536660)));
        }
        lore.set(0, name);
        if (shiny && textIndicators) {
            newLore.add((Component)LoreEnhancements.translate("egg.shiny.text", new Object[0]).withStyle(ChatFormatting.YELLOW));
            newLore.add((Component)Component.literal((String)" "));
        }
        List<Component> hatchProgress = enhancedEggLore.getHatchProgress(lore);
        boolean spacer = false;
        if (hatchProgress != null && !hatchProgress.isEmpty()) {
            newLore.addAll(hatchProgress);
            spacer = true;
        }
        String nature = enhancedEggLore.getNature();
        String abilityName = enhancedEggLore.getAbility();
        String form = enhancedEggLore.getForm();
        String pokeBall = enhancedEggLore.getPokeBall();
        if ((nature != null || abilityName != null || form != null || pokeBall != null) && spacer) {
            newLore.add((Component)Component.literal((String)" "));
            spacer = false;
        }
        if (nature != null) {
            if (nature.contains(":")) {
                nature = StringUtils.capitalize((String)nature.substring(nature.indexOf(58) + 1));
            }
            newLore.add((Component)LoreEnhancements.translate("egg.nature", new Object[0]).withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)nature).withStyle(ChatFormatting.WHITE)));
            spacer = true;
        }
        if (abilityName != null) {
            newLore.add((Component)LoreEnhancements.translate("egg.ability", new Object[0]).withColor(new Color(16766976).getRGB()).append((Component)Component.literal((String)StringUtils.capitalize((String)abilityName)).withStyle(ChatFormatting.WHITE)));
            spacer = true;
        }
        if (form != null) {
            newLore.add((Component)LoreEnhancements.translate("egg.form", new Object[0]).withColor(new Color(0xFFBB00).getRGB()).append((Component)Component.literal((String)StringUtils.capitalize((String)form)).withStyle(ChatFormatting.WHITE)));
            spacer = true;
        }
        if (pokeBall != null) {
            newLore.add((Component)LoreEnhancements.translate("egg.pokeball", new Object[0]).withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)StringUtils.capitalize((String)pokeBall)).withStyle(ChatFormatting.WHITE)));
            spacer = true;
        }
        if (enhancedEggLore.hasIVs()) {
            Integer hp = enhancedEggLore.getHpIV();
            Integer attack = enhancedEggLore.getAtkIV();
            Integer defense = enhancedEggLore.getDefIV();
            Integer spAttack = enhancedEggLore.getSpAtkIV();
            Integer spDefense = enhancedEggLore.getSpDefIV();
            Integer speed = enhancedEggLore.getSpeedIV();
            if (spacer) {
                newLore.add((Component)Component.literal((String)" "));
            }
            Integer sum = null;
            if (hp != null && hp != -1) {
                newLore.add((Component)LoreEnhancements.iv("hp", ChatFormatting.GREEN, hp));
                sum = hp;
            }
            if (attack != null && attack != -1) {
                newLore.add((Component)LoreEnhancements.iv("attack", ChatFormatting.RED, attack));
                sum = sum == null ? attack : sum + attack;
            }
            if (defense != null && defense != -1) {
                newLore.add((Component)LoreEnhancements.iv("defense", ChatFormatting.GOLD, defense));
                sum = sum == null ? defense : sum + defense;
            }
            if (spAttack != null && spAttack != -1) {
                newLore.add((Component)LoreEnhancements.iv("sp_attack", ChatFormatting.LIGHT_PURPLE, spAttack));
                sum = sum == null ? spAttack : sum + spAttack;
            }
            if (spDefense != null && spDefense != -1) {
                newLore.add((Component)LoreEnhancements.iv("sp_defense", ChatFormatting.YELLOW, spDefense));
                sum = sum == null ? spDefense : sum + spDefense;
            }
            if (speed != null && speed != -1) {
                newLore.add((Component)LoreEnhancements.iv("speed", ChatFormatting.AQUA, speed));
                sum = sum == null ? speed : sum + speed;
            }
            if (sum != null) {
                int average = (int)((double)sum.intValue() / 6.0);
                newLore.add((Component)LoreEnhancements.iv("average", ChatFormatting.WHITE, average));
            }
            if (perfect && textIndicators) {
                newLore.add((Component)LoreEnhancements.translate("egg.perfect.text", new Object[0]).withStyle(ChatFormatting.WHITE));
            } else if (minimum && textIndicators) {
                newLore.add((Component)LoreEnhancements.translate("egg.minimum.text", new Object[0]).withStyle(ChatFormatting.WHITE));
            }
        }
    }

    public static MutableComponent iv(String stat, ChatFormatting color, int iv) {
        return LoreEnhancements.translate("egg.iv." + stat, new Object[0]).withStyle(color).append((Component)Component.literal((String)(Screen.hasShiftDown() ? Math.round((double)iv / 31.0 * 100.0) + "%" : Integer.toString(iv))).withStyle(ChatFormatting.WHITE));
    }

    public static MutableComponent translate(String key, Object ... args) {
        return Component.translatable((String)(BASE_KEY + key), (Object[])args);
    }
}

