/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc.search.predicates;

import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.SearchPredicate;

public class EggGroupPredicate
implements SearchPredicate {
    public static final String KEY = "egg_group=";
    private static final List<String> COMPLETION;
    private final EggGroup eggGroup;

    public EggGroupPredicate() {
        this.eggGroup = null;
        SearchPredicate.register(this);
    }

    public EggGroupPredicate(EggGroup eggGroup) {
        this.eggGroup = eggGroup;
    }

    @Override
    public void suggest(SuggestionsBuilder builder) {
        String remaining = builder.getRemainingLowerCase();
        if (remaining.startsWith(KEY)) {
            for (String completion : COMPLETION) {
                if (!completion.startsWith(remaining)) continue;
                builder.suggest(completion);
            }
        } else if (KEY.startsWith(remaining)) {
            builder.suggest(KEY);
        }
    }

    public boolean test(Pokemon pokemon) {
        return this.eggGroup != null && pokemon.getSpecies().getEggGroups().contains(this.eggGroup);
    }

    static {
        ArrayList<CallSite> completion = new ArrayList<CallSite>();
        for (EggGroup group : EggGroup.values()) {
            completion.add((CallSite)((Object)(KEY + group.name().toLowerCase(Locale.ROOT))));
        }
        COMPLETION = List.copyOf(completion);
    }
}

