/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.utils;

import com.cobblemon.mod.common.client.gui.pc.PCGUIConfiguration;
import com.cobblemon.mod.common.client.storage.ClientPC;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class Utils {
    private static final Map<String, Boolean> MOD_ENABLED_CACHE = new HashMap<String, Boolean>();
    private static Function<String, Boolean> modEnabledFunction = id -> false;
    private static Function<String, String> modVersionFunction = id -> "unknown";
    public static CompletableFuture<Void> moveAllPokemonFuture = null;
    public static ClientPC summaryPC = null;
    public static PCGUIConfiguration summaryConfig = null;
    public static Set<ResourceLocation> unseenWallpapers = null;
    public static boolean summaryFromPC = false;

    public static void playSound(SoundEvent sound) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f));
    }

    public static String get(CompoundTag nbt, String key, String def) {
        Tag tag;
        if (nbt != null && (tag = nbt.get(key)) instanceof StringTag) {
            StringTag nbtString = (StringTag)tag;
            return nbtString.getAsString();
        }
        return def;
    }

    public static boolean get(CompoundTag nbt, String key, boolean def) {
        Tag tag;
        if (nbt != null && (tag = nbt.get(key)) instanceof ByteTag) {
            ByteTag nbtByte = (ByteTag)tag;
            return nbtByte.getAsByte() == 1;
        }
        return def;
    }

    public static int get(CompoundTag nbt, String key, int def) {
        Tag tag;
        if (nbt != null && (tag = nbt.get(key)) instanceof IntTag) {
            IntTag nbtInt = (IntTag)tag;
            return nbtInt.getAsInt();
        }
        return def;
    }

    public static short get(CompoundTag nbt, String key, short def) {
        Tag tag;
        if (nbt != null && (tag = nbt.get(key)) instanceof ShortTag) {
            ShortTag nbtShort = (ShortTag)tag;
            return nbtShort.getAsShort();
        }
        return def;
    }

    public static double get(CompoundTag nbt, String key, double def) {
        Tag tag;
        if (nbt != null && (tag = nbt.get(key)) instanceof DoubleTag) {
            DoubleTag nbtDouble = (DoubleTag)tag;
            return nbtDouble.getAsDouble();
        }
        return def;
    }

    public static boolean modEnabled(String id) {
        Boolean cached = MOD_ENABLED_CACHE.get(id);
        if (cached != null) {
            return cached;
        }
        boolean enabled = modEnabledFunction.apply(id);
        MOD_ENABLED_CACHE.put(id, enabled);
        return enabled;
    }

    public static String modVersion(String id) {
        return modVersionFunction.apply(id);
    }

    public static void setModEnabledFunction(Function<String, Boolean> function) {
        modEnabledFunction = function;
    }

    public static void setModVersionFunction(Function<String, String> function) {
        modVersionFunction = function;
    }
}

