/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features.pc.search;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.egg.EggGroup;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.SearchPredicate;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.predicates.EggGroupPredicate;
import me.justahuman.more_cobblemon_tweaks.features.pc.search.predicates.NameOrSpeciesPredicate;

public class Search {
    private static final PokemonProperties NONE = new PokemonProperties();
    public static Search instance = null;
    private final Set<SearchPredicate> options;
    private final Set<UUID> passedMons = new HashSet<UUID>();
    private final Set<UUID> failedMons = new HashSet<UUID>();

    protected Search(Set<SearchPredicate> options) {
        this.options = options;
    }

    public boolean passes(Pokemon pokemon) {
        UUID uuid = pokemon.getUuid();
        if (this.passedMons.contains(uuid)) {
            return true;
        }
        if (this.failedMons.contains(uuid)) {
            return false;
        }
        for (SearchPredicate option : this.options) {
            if (option.passes(pokemon)) continue;
            this.failedMons.add(uuid);
            return false;
        }
        this.passedMons.add(uuid);
        return true;
    }

    public static Search of(String search) {
        if (search == null || search.isBlank()) {
            return null;
        }
        search = search.toLowerCase(Locale.ROOT).trim();
        String[] options = search.split(" ");
        HashSet<SearchPredicate> searchOptions = new HashSet<SearchPredicate>();
        for (String option : options) {
            SearchPredicate searchOption;
            boolean inverted = false;
            if (option.startsWith("!")) {
                inverted = true;
                option = option.substring(1);
            }
            if ((searchOption = SearchPredicate.FIXED.get(option)) == null) {
                String[] parts = option.split("=", 2);
                if (parts.length == 2) {
                    if ("egg_group=".equalsIgnoreCase(parts[0] + "=")) {
                        try {
                            EggGroup group = EggGroup.valueOf((String)parts[1].toUpperCase(Locale.ROOT));
                            searchOption = new EggGroupPredicate(group);
                        }
                        catch (IllegalArgumentException group) {}
                    } else {
                        searchOption = SearchPredicate.FIXED.get(parts[0]);
                        if (parts[1].equals("false") || parts[1].equals("no")) {
                            boolean bl = inverted = !inverted;
                        }
                    }
                }
                if (searchOption == null) {
                    PokemonProperties filter = PokemonProperties.Companion.parse(option);
                    searchOption = !filter.matches(NONE) ? arg_0 -> ((PokemonProperties)filter).matches(arg_0) : new NameOrSpeciesPredicate(option);
                }
            }
            if (inverted) {
                searchOptions.add(searchOption.invert());
                continue;
            }
            searchOptions.add(searchOption);
        }
        return new Search(searchOptions);
    }
}

