/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.mixins;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.client.gui.pc.BoxStorageSlot;
import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.client.gui.pc.ReleaseConfirmButton;
import com.cobblemon.mod.common.client.gui.pc.StorageWidget;
import com.cobblemon.mod.common.client.gui.summary.widgets.SoundlessWidget;
import com.cobblemon.mod.common.net.messages.server.storage.pc.ReleasePCPokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.ArrayList;
import java.util.List;
import me.justahuman.more_cobblemon_tweaks.api.MultiSelector;
import me.justahuman.more_cobblemon_tweaks.api.MultiSelectorState;
import me.justahuman.more_cobblemon_tweaks.config.ModConfig;
import me.justahuman.more_cobblemon_tweaks.mixins.ButtonAccessor;
import me.justahuman.more_cobblemon_tweaks.utils.Utils;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StorageWidget.class}, remap=false)
public abstract class StorageWidgetMixin
extends SoundlessWidget
implements MultiSelector {
    @Final
    @Shadow
    private PCGUI pcGui;
    @Final
    @Shadow
    private ReleaseConfirmButton releaseYesButton;
    @Shadow
    private int box;
    @Unique
    private PCPosition moreCobblemonTweaks$lastPosition = null;
    @Unique
    private final List<PCPosition> moreCobblemonTweaks$selectedPositions = new ArrayList<PCPosition>();

    private StorageWidgetMixin(int pX, int pY, int pWidth, int pHeight, @NotNull class_2561 component) {
        super(pX, pY, pWidth, pHeight, component);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void releaseMultiselect(CallbackInfo ci) {
        class_4185.class_4241 original = ((ButtonAccessor)this.releaseYesButton).getOnPress();
        ((ButtonAccessor)this.releaseYesButton).setOnPress(button -> {
            if (!this.moreCobblemonTweaks$isMultiSelecting()) {
                original.onPress(button);
                return;
            }
            for (PCPosition position : this.moreCobblemonTweaks$getSelectedPositions()) {
                Pokemon pokemon = this.pcGui.getPc().get(position);
                if (pokemon == null) continue;
                CobblemonNetwork.INSTANCE.sendToServer((NetworkPacket)new ReleasePCPokemonPacket(pokemon.getUuid(), position));
            }
            this.playSound(CobblemonSounds.PC_RELEASE);
            this.resetSelected();
            this.setDisplayConfirmRelease(false);
            this.moreCobblemonTweaks$clearMultiSelection();
        });
    }

    @Inject(at={@At(value="TAIL")}, method={"setBox"})
    public void setBox(int value, CallbackInfo ci) {
        Utils.currentBox = this.box;
        this.moreCobblemonTweaks$clearMultiSelection();
    }

    @Inject(at={@At(value="HEAD")}, method={"onStorageSlotClicked"}, cancellable=true)
    public void onSlotClicked(class_4185 button, CallbackInfo ci) {
        boolean enabling;
        if (!button.method_49606()) {
            ci.cancel();
            return;
        }
        if (!this.moreCobblemonTweaks$isMultiSelecting()) {
            return;
        }
        ci.cancel();
        if (!(button instanceof BoxStorageSlot)) {
            return;
        }
        BoxStorageSlot slot = (BoxStorageSlot)button;
        PCPosition lastPosition = this.moreCobblemonTweaks$lastPosition;
        PCPosition clickedPosition = slot.getPosition();
        boolean bl = enabling = !this.moreCobblemonTweaks$selectedPositions.contains(clickedPosition);
        if (lastPosition != null && class_437.method_25442()) {
            int from = Math.min(lastPosition.getSlot(), clickedPosition.getSlot());
            int to = Math.max(lastPosition.getSlot(), clickedPosition.getSlot());
            for (int i = from; i <= to; ++i) {
                PCPosition position = new PCPosition(clickedPosition.getBox(), i);
                this.moreCobblemonTweaks$selectedPositions.remove(position);
                if (!enabling) continue;
                this.moreCobblemonTweaks$selectedPositions.add(position);
            }
        } else {
            this.moreCobblemonTweaks$toggleSelected(clickedPosition);
            this.moreCobblemonTweaks$lastPosition = clickedPosition;
        }
        this.playSound(enabling ? CobblemonSounds.PC_GRAB : CobblemonSounds.PC_DROP);
    }

    @Unique
    private void moreCobblemonTweaks$toggleSelected(PCPosition position) {
        if (!this.moreCobblemonTweaks$selectedPositions.remove(position)) {
            this.moreCobblemonTweaks$selectedPositions.add(position);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canDeleteSelected"}, cancellable=true)
    public void canDelete(CallbackInfoReturnable<Boolean> cir) {
        if (this.moreCobblemonTweaks$isMultiSelecting()) {
            cir.setReturnValue((Object)(!this.moreCobblemonTweaks$selectedPositions.isEmpty() ? 1 : 0));
        }
    }

    @ModifyArg(method={"renderWidget"}, index=1, at=@At(value="INVOKE", target="Lcom/cobblemon/mod/common/api/gui/GuiUtilsKt;blitk$default(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/resources/ResourceLocation;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;ZFILjava/lang/Object;)V", ordinal=1), remap=true)
    public class_2960 overrideOverlayTexture(class_2960 texture) {
        class_2960 newTexture;
        if (ModConfig.isEnabled("custom_pc_wallpapers") && (newTexture = ModConfig.getBoxTexture(Utils.currentBox)) != null) {
            return newTexture;
        }
        return texture;
    }

    @Inject(at={@At(value="HEAD")}, method={"mouseClicked"}, cancellable=true, remap=true)
    public void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (!this.field_22764) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public boolean moreCobblemonTweaks$isMultiSelecting() {
        return ((MultiSelectorState)this.pcGui).moreCobblemonTweaks$isMultiSelecting();
    }

    @Override
    public List<PCPosition> moreCobblemonTweaks$getSelectedPositions() {
        return this.moreCobblemonTweaks$selectedPositions;
    }

    @Override
    public List<Pokemon> moreCobblemonTweaks$getSelectedPokemon() {
        ArrayList<Pokemon> selectedPokemon = new ArrayList<Pokemon>();
        for (PCPosition position : this.moreCobblemonTweaks$selectedPositions) {
            Pokemon pokemon = this.pcGui.getPc().get(position);
            if (pokemon == null) continue;
            selectedPokemon.add(pokemon);
        }
        return selectedPokemon;
    }

    @Override
    public void moreCobblemonTweaks$clearMultiSelection() {
        this.moreCobblemonTweaks$selectedPositions.clear();
    }

    @Shadow
    public abstract void setDisplayConfirmRelease(boolean var1);

    @Shadow
    protected abstract void playSound(class_3414 var1);

    @Shadow
    protected abstract void resetSelected();
}

