/*
 * Decompiled with CFR 0.152.
 */
package net.moznion.uribuildertiny;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import net.moznion.uribuildertiny.EntityURLEncoder;

class URLEncoder {
    private final EntityURLEncoder entityURLEncoder;

    URLEncoder(EntityURLEncoder entityURLEncoder) {
        this.entityURLEncoder = entityURLEncoder;
    }

    public String encode(@NonNull Object input) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        return this.entityURLEncoder.encode(input);
    }

    public List<String> encode(@NonNull List<?> input) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        ArrayList<String> encodedList = new ArrayList<String>();
        for (Object item : input) {
            encodedList.add(this.encode(item.toString()));
        }
        return encodedList;
    }

    public Map<String, String> encode(@NonNull Map<String, ?> input) {
        if (input == null) {
            throw new NullPointerException("input");
        }
        HashMap<String, String> encodedMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> kv : input.entrySet()) {
            encodedMap.put(this.encode(kv.getKey()), this.encode(kv.getValue()));
        }
        return encodedMap;
    }
}

